/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.player;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import net.kyori.adventure.text.object.PlayerHeadObjectContents;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.utils.Either;
import org.jetbrains.annotations.Nullable;

public record GameProfile(UUID uuid, String name, List<Property> properties) {
    public static final int MAX_PROPERTIES = 1024;
    public static final NetworkBuffer.Type<GameProfile> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.UUID, GameProfile::uuid, NetworkBuffer.STRING, GameProfile::name, Property.SERIALIZER.list(1024), GameProfile::properties, GameProfile::new);
    public static final StructCodec<GameProfile> CODEC = StructCodec.struct("id", Codec.UUID, GameProfile::uuid, "name", Codec.STRING, GameProfile::name, "properties", Property.LIST_CODEC.optional(List.of()), GameProfile::properties, GameProfile::new);

    public GameProfile {
        Objects.requireNonNull(uuid, "uuid");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(properties, "properties");
        if (name.isBlank()) {
            throw new IllegalArgumentException("Name cannot be blank");
        }
        if (name.length() > 16) {
            throw new IllegalArgumentException("Name length cannot be greater than 16 characters");
        }
        properties = List.copyOf(properties);
    }

    public GameProfile(UUID uuid, String name) {
        this(uuid, name, List.of());
    }

    public record Property(String name, String value, @Nullable String signature) implements PlayerHeadObjectContents.ProfileProperty
    {
        public static final NetworkBuffer.Type<Property> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.STRING, Property::name, NetworkBuffer.STRING, Property::value, NetworkBuffer.STRING.optional(), Property::signature, Property::new);
        public static final Codec<Property> CODEC = StructCodec.struct("name", Codec.STRING, Property::name, "value", Codec.STRING, Property::value, "signature", Codec.STRING.optional(), Property::signature, Property::new);
        public static final Codec<List<Property>> LIST_CODEC = Codec.Either(Codec.STRING.mapValue(Codec.STRING), CODEC.list()).transform(either -> either.unify(map -> map.entrySet().stream().map(entry -> new Property((String)entry.getKey(), (String)entry.getValue(), null)).toList(), Function.identity()), Either::right);

        public Property(String name, String value, @Nullable String signature) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(value, "value");
        }

        public Property(String name, String value) {
            this(name, value, null);
        }
    }
}

