/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.player;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.object.PlayerHeadObjectContents;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.entity.PlayerSkin;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.player.GameProfile;
import net.minestom.server.utils.Either;
import org.jetbrains.annotations.Nullable;

public record ResolvableProfile(Either<GameProfile, Partial> profile, PlayerSkin.Patch patch) implements PlayerHeadObjectContents.SkinSource
{
    public static final ResolvableProfile EMPTY = new ResolvableProfile(Either.right(Partial.EMPTY), PlayerSkin.Patch.EMPTY);
    public static final NetworkBuffer.Type<ResolvableProfile> NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.Either(GameProfile.SERIALIZER, Partial.NETWORK_TYPE), ResolvableProfile::profile, PlayerSkin.Patch.NETWORK_TYPE, ResolvableProfile::patch, ResolvableProfile::new);
    public static final StructCodec<ResolvableProfile> CODEC = StructCodec.struct("$$inline$$", Codec.EitherStruct(GameProfile.CODEC, Partial.CODEC), ResolvableProfile::profile, "$$inline$$", PlayerSkin.Patch.CODEC, ResolvableProfile::patch, ResolvableProfile::new);

    public ResolvableProfile {
        Objects.requireNonNull(profile, "profile");
        Objects.requireNonNull(patch, "patch");
    }

    public ResolvableProfile(GameProfile profile) {
        this(Either.left(profile), PlayerSkin.Patch.EMPTY);
    }

    public ResolvableProfile(GameProfile profile, PlayerSkin.Patch patch) {
        this(Either.left(profile), patch);
    }

    public ResolvableProfile(Partial partial) {
        this(Either.right(partial), PlayerSkin.Patch.EMPTY);
    }

    public ResolvableProfile(Partial partial, PlayerSkin.Patch patch) {
        this(Either.right(partial), patch);
    }

    public ResolvableProfile(PlayerSkin skin) {
        this(new Partial(null, null, List.of(new GameProfile.Property("textures", skin.textures(), skin.signature()))));
    }

    public static ResolvableProfile fromPlayerHeadContents(PlayerHeadObjectContents contents) {
        Key texture = contents.texture();
        if (texture != null) {
            return new ResolvableProfile(Partial.EMPTY, new PlayerSkin.Patch(texture));
        }
        ArrayList<GameProfile.Property> properties = new ArrayList<GameProfile.Property>(contents.profileProperties().size());
        for (PlayerHeadObjectContents.ProfileProperty property : contents.profileProperties()) {
            GameProfile.Property p;
            properties.add(property instanceof GameProfile.Property ? (p = (GameProfile.Property)property) : new GameProfile.Property(property.name(), property.value(), property.signature()));
        }
        return new ResolvableProfile(new Partial(contents.name(), contents.id(), properties));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void applySkinToPlayerHeadContents(PlayerHeadObjectContents.Builder builder) {
        if (this.patch.body() != null) {
            builder.texture(this.patch.body());
        }
        Either<GameProfile, Partial> either = this.profile;
        Objects.requireNonNull(either);
        Either<GameProfile, Partial> either2 = either;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Either.Left.class, Either.Right.class}, either2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Either.Left left = (Either.Left)either2;
                GameProfile gameProfile = (GameProfile)left.value();
                GameProfile gameProfile2 = gameProfile;
                builder.name(gameProfile2.name());
                builder.id(gameProfile2.uuid());
                for (GameProfile.Property property : gameProfile2.properties()) {
                    builder.profileProperty(property);
                }
                return;
            }
            case 1: {
                Partial partial2;
                Either.Right right = (Either.Right)either2;
                try {
                    Partial partial = (Partial)right.value();
                    partial2 = partial;
                    builder.name(partial2.name());
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                builder.id(partial2.uuid());
                for (GameProfile.Property property : partial2.properties()) {
                    builder.profileProperty(property);
                }
                return;
            }
        }
    }

    public record Partial(@Nullable String name, @Nullable UUID uuid, List<GameProfile.Property> properties) {
        public static final Partial EMPTY = new Partial(null, null, List.of());
        public static final NetworkBuffer.Type<Partial> NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.STRING.optional(), Partial::name, NetworkBuffer.UUID.optional(), Partial::uuid, GameProfile.Property.SERIALIZER.list(1024), Partial::properties, Partial::new);
        public static final StructCodec<Partial> CODEC = StructCodec.struct("name", Codec.STRING.optional(), Partial::name, "uuid", Codec.UUID.optional(), Partial::uuid, "properties", GameProfile.Property.LIST_CODEC, Partial::properties, Partial::new);

        public Partial(@Nullable String name, @Nullable UUID uuid, List<GameProfile.Property> properties) {
            properties = List.copyOf(properties);
        }
    }
}

