/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.ping;

import com.google.gson.JsonObject;
import java.util.function.Function;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minestom.server.MinecraftServer;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.ping.Status;

public enum ServerListPingType {
    MODERN_FULL_RGB(data -> ServerListPingType.getModernPingResponse(data, true).toString()),
    MODERN_NAMED_COLORS(data -> ServerListPingType.getModernPingResponse(data, false).toString()),
    LEGACY_VERSIONED(data -> ServerListPingType.getLegacyPingResponse(data, true)),
    LEGACY_UNVERSIONED(data -> ServerListPingType.getLegacyPingResponse(data, false)),
    OPEN_TO_LAN(ServerListPingType::getOpenToLANPing);

    private final Function<Status, String> pingResponseCreator;
    private static final String LAN_PING_FORMAT = "[MOTD]%s[/MOTD][AD]%s[/AD]";
    private static final GsonComponentSerializer FULL_RGB;
    private static final GsonComponentSerializer NAMED_RGB;
    private static final LegacyComponentSerializer SECTION;

    private ServerListPingType(Function<Status, String> pingResponseCreator) {
        this.pingResponseCreator = pingResponseCreator;
    }

    public String getPingResponse(Status status) {
        return this.pingResponseCreator.apply(status);
    }

    public static String getOpenToLANPing(Status status) {
        return String.format(LAN_PING_FORMAT, SECTION.serialize(status.description()), MinecraftServer.getServer().getPort());
    }

    public static String getLegacyPingResponse(Status status, boolean supportsVersions) {
        int maxPlayers;
        String motd = SECTION.serialize(status.description());
        Status.PlayerInfo playerInfo = status.playerInfo();
        int onlinePlayers = playerInfo == null ? 0 : playerInfo.onlinePlayers();
        int n = maxPlayers = playerInfo == null ? 1 : playerInfo.maxPlayers();
        if (supportsVersions) {
            return String.format("\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", status.versionInfo().protocolVersion(), status.versionInfo().name(), motd, onlinePlayers, maxPlayers);
        }
        return String.format("%s\u00a7%d\u00a7%d", motd, onlinePlayers, maxPlayers);
    }

    public static JsonObject getModernPingResponse(Status status, boolean supportsFullRgb) {
        JsonObject element = (JsonObject)Status.CODEC.encode(Transcoder.JSON, status).orElseThrow();
        if (!supportsFullRgb) {
            GsonComponentSerializer serializer = GsonComponentSerializer.colorDownsamplingGson();
            element.add("description", serializer.serializeToTree(status.description()));
        }
        return element;
    }

    public static ServerListPingType fromModernProtocolVersion(int version) {
        return version >= 713 ? MODERN_FULL_RGB : MODERN_NAMED_COLORS;
    }

    static {
        FULL_RGB = GsonComponentSerializer.gson();
        NAMED_RGB = GsonComponentSerializer.colorDownsamplingGson();
        SECTION = LegacyComponentSerializer.legacySection();
    }
}

