/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.Nullable;

public enum RecipeProperty implements Keyed
{
    SMITHING_BASE("smithing_base"),
    SMITHING_TEMPLATE("smithing_template"),
    SMITHING_ADDITION("smithing_addition"),
    FURNACE_INPUT("furnace_input"),
    BLAST_FURNACE_INPUT("blast_furnace_input"),
    SMOKER_INPUT("smoker_input"),
    CAMPFIRE_INPUT("campfire_input");

    private static final Map<Key, RecipeProperty> BY_KEY;
    public static final NetworkBuffer.Type<RecipeProperty> NETWORK_TYPE;
    private final Key key;

    @Nullable
    public static RecipeProperty fromKey(String key) {
        return RecipeProperty.fromKey(Key.key(key));
    }

    @Nullable
    public static RecipeProperty fromKey(Key key) {
        return BY_KEY.get(key);
    }

    private RecipeProperty(String id) {
        this.key = Key.key("minecraft", id);
    }

    @Override
    public Key key() {
        return this.key;
    }

    static {
        BY_KEY = Arrays.stream(RecipeProperty.values()).collect(Collectors.toMap(RecipeProperty::key, Function.identity()));
        NETWORK_TYPE = NetworkBuffer.STRING.transform(key -> Objects.requireNonNull(RecipeProperty.fromKey(key)), recipeProperty -> recipeProperty.key().asMinimalString());
    }
}

