/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe.display;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;

public enum SlotDisplayType implements StaticProtocolObject<SlotDisplayType>
{
    EMPTY("empty"),
    ANY_FUEL("any_fuel"),
    ITEM("item"),
    ITEM_STACK("item_stack"),
    TAG("tag"),
    SMITHING_TRIM("smithing_trim"),
    WITH_REMAINDER("with_remainder"),
    COMPOSITE("composite");

    private static final Map<Key, SlotDisplayType> BY_KEY;
    public static final NetworkBuffer.Type<SlotDisplayType> NETWORK_TYPE;
    public static final Codec<SlotDisplayType> CODEC;
    private final Key key;

    private SlotDisplayType(String key) {
        this.key = Key.key(key);
    }

    @Override
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }

    static {
        BY_KEY = Arrays.stream(SlotDisplayType.values()).collect(Collectors.toUnmodifiableMap(SlotDisplayType::key, Function.identity()));
        NETWORK_TYPE = NetworkBuffer.Enum(SlotDisplayType.class);
        CODEC = Codec.KEY.transform(BY_KEY::get, SlotDisplayType::key);
    }
}

