/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import net.minestom.server.codec.StructCodec;
import net.minestom.server.dialog.Dialog;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.damage.DamageType;
import net.minestom.server.entity.metadata.animal.ChickenVariant;
import net.minestom.server.entity.metadata.animal.CowVariant;
import net.minestom.server.entity.metadata.animal.FrogVariant;
import net.minestom.server.entity.metadata.animal.PigVariant;
import net.minestom.server.entity.metadata.animal.tameable.CatVariant;
import net.minestom.server.entity.metadata.animal.tameable.WolfSoundVariant;
import net.minestom.server.entity.metadata.animal.tameable.WolfVariant;
import net.minestom.server.entity.metadata.other.PaintingVariant;
import net.minestom.server.game.GameEvent;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.banner.BannerPattern;
import net.minestom.server.instance.block.jukebox.JukeboxSong;
import net.minestom.server.instance.fluid.Fluid;
import net.minestom.server.item.Material;
import net.minestom.server.item.armor.TrimMaterial;
import net.minestom.server.item.armor.TrimPattern;
import net.minestom.server.item.enchant.Enchantment;
import net.minestom.server.item.enchant.EntityEffect;
import net.minestom.server.item.enchant.LevelBasedValue;
import net.minestom.server.item.enchant.LocationEffect;
import net.minestom.server.item.enchant.ValueEffect;
import net.minestom.server.item.instrument.Instrument;
import net.minestom.server.message.ChatType;
import net.minestom.server.potion.PotionEffect;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registry;
import net.minestom.server.world.DimensionType;
import net.minestom.server.world.biome.Biome;

public interface Registries {
    default public Registry<Block> blocks() {
        return Block.staticRegistry();
    }

    default public Registry<Material> material() {
        return Material.staticRegistry();
    }

    default public Registry<PotionEffect> potionEffect() {
        return PotionEffect.staticRegistry();
    }

    default public Registry<EntityType> entityType() {
        return EntityType.staticRegistry();
    }

    default public Registry<Fluid> fluid() {
        return Fluid.staticRegistry();
    }

    default public Registry<GameEvent> gameEvent() {
        return GameEvent.staticRegistry();
    }

    public DynamicRegistry<ChatType> chatType();

    public DynamicRegistry<DimensionType> dimensionType();

    public DynamicRegistry<Biome> biome();

    public DynamicRegistry<DamageType> damageType();

    public DynamicRegistry<TrimMaterial> trimMaterial();

    public DynamicRegistry<TrimPattern> trimPattern();

    public DynamicRegistry<BannerPattern> bannerPattern();

    public DynamicRegistry<Enchantment> enchantment();

    public DynamicRegistry<PaintingVariant> paintingVariant();

    public DynamicRegistry<JukeboxSong> jukeboxSong();

    public DynamicRegistry<Instrument> instrument();

    public DynamicRegistry<WolfVariant> wolfVariant();

    public DynamicRegistry<WolfSoundVariant> wolfSoundVariant();

    public DynamicRegistry<CatVariant> catVariant();

    public DynamicRegistry<ChickenVariant> chickenVariant();

    public DynamicRegistry<CowVariant> cowVariant();

    public DynamicRegistry<FrogVariant> frogVariant();

    public DynamicRegistry<PigVariant> pigVariant();

    public DynamicRegistry<Dialog> dialog();

    public DynamicRegistry<StructCodec<? extends LevelBasedValue>> enchantmentLevelBasedValues();

    public DynamicRegistry<StructCodec<? extends ValueEffect>> enchantmentValueEffects();

    public DynamicRegistry<StructCodec<? extends EntityEffect>> enchantmentEntityEffects();

    public DynamicRegistry<StructCodec<? extends LocationEffect>> enchantmentLocationEffects();

    public static class Delegating
    implements Registries {
        private final Registries delegate;

        public Delegating(Registries delegate) {
            this.delegate = delegate;
        }

        @Override
        public Registry<Block> blocks() {
            return this.delegate.blocks();
        }

        @Override
        public Registry<Material> material() {
            return this.delegate.material();
        }

        @Override
        public Registry<PotionEffect> potionEffect() {
            return this.delegate.potionEffect();
        }

        @Override
        public Registry<EntityType> entityType() {
            return this.delegate.entityType();
        }

        @Override
        public Registry<Fluid> fluid() {
            return this.delegate.fluid();
        }

        @Override
        public Registry<GameEvent> gameEvent() {
            return this.delegate.gameEvent();
        }

        @Override
        public DynamicRegistry<ChatType> chatType() {
            return this.delegate.chatType();
        }

        @Override
        public DynamicRegistry<DimensionType> dimensionType() {
            return this.delegate.dimensionType();
        }

        @Override
        public DynamicRegistry<Biome> biome() {
            return this.delegate.biome();
        }

        @Override
        public DynamicRegistry<DamageType> damageType() {
            return this.delegate.damageType();
        }

        @Override
        public DynamicRegistry<TrimMaterial> trimMaterial() {
            return this.delegate.trimMaterial();
        }

        @Override
        public DynamicRegistry<TrimPattern> trimPattern() {
            return this.delegate.trimPattern();
        }

        @Override
        public DynamicRegistry<BannerPattern> bannerPattern() {
            return this.delegate.bannerPattern();
        }

        @Override
        public DynamicRegistry<Enchantment> enchantment() {
            return this.delegate.enchantment();
        }

        @Override
        public DynamicRegistry<PaintingVariant> paintingVariant() {
            return this.delegate.paintingVariant();
        }

        @Override
        public DynamicRegistry<JukeboxSong> jukeboxSong() {
            return this.delegate.jukeboxSong();
        }

        @Override
        public DynamicRegistry<Instrument> instrument() {
            return this.delegate.instrument();
        }

        @Override
        public DynamicRegistry<WolfVariant> wolfVariant() {
            return this.delegate.wolfVariant();
        }

        @Override
        public DynamicRegistry<WolfSoundVariant> wolfSoundVariant() {
            return this.delegate.wolfSoundVariant();
        }

        @Override
        public DynamicRegistry<CatVariant> catVariant() {
            return this.delegate.catVariant();
        }

        @Override
        public DynamicRegistry<ChickenVariant> chickenVariant() {
            return this.delegate.chickenVariant();
        }

        @Override
        public DynamicRegistry<CowVariant> cowVariant() {
            return this.delegate.cowVariant();
        }

        @Override
        public DynamicRegistry<FrogVariant> frogVariant() {
            return this.delegate.frogVariant();
        }

        @Override
        public DynamicRegistry<PigVariant> pigVariant() {
            return this.delegate.pigVariant();
        }

        @Override
        public DynamicRegistry<Dialog> dialog() {
            return this.delegate.dialog();
        }

        @Override
        public DynamicRegistry<StructCodec<? extends LevelBasedValue>> enchantmentLevelBasedValues() {
            return this.delegate.enchantmentLevelBasedValues();
        }

        @Override
        public DynamicRegistry<StructCodec<? extends ValueEffect>> enchantmentValueEffects() {
            return this.delegate.enchantmentValueEffects();
        }

        @Override
        public DynamicRegistry<StructCodec<? extends EntityEffect>> enchantmentEntityEffects() {
            return this.delegate.enchantmentEntityEffects();
        }

        @Override
        public DynamicRegistry<StructCodec<? extends LocationEffect>> enchantmentLocationEffects() {
            return this.delegate.enchantmentLocationEffects();
        }
    }

    @FunctionalInterface
    public static interface Selector<T> {
        public Registry<T> select(Registries var1);
    }
}

