/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.Holder;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryCodecs;
import net.minestom.server.registry.RegistryKeyImpl;
import net.minestom.server.registry.RegistryNetworkTypes;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface RegistryKey<T>
extends Holder<T>,
Keyed {
    public static <T> NetworkBuffer.Type<RegistryKey<T>> networkType(Registries.Selector<T> selector) {
        return new RegistryNetworkTypes.RegistryKeyImpl<T>(selector);
    }

    public static <T> Codec<RegistryKey<T>> codec(Registries.Selector<T> selector) {
        return new RegistryCodecs.RegistryKeyImpl<T>(selector);
    }

    public static <T> NetworkBuffer.Type<RegistryKey<T>> uncheckedNetworkType() {
        return NetworkBuffer.KEY.transform(RegistryKeyImpl::new, Keyed::key);
    }

    public static <T> Codec<RegistryKey<T>> uncheckedCodec() {
        return Codec.KEY.transform(RegistryKeyImpl::new, Keyed::key);
    }

    @ApiStatus.Internal
    public static <T> RegistryKey<T> unsafeOf(String key) {
        return RegistryKey.unsafeOf(Key.key(key));
    }

    @ApiStatus.Internal
    public static <T> RegistryKey<T> unsafeOf(Key key) {
        return new RegistryKeyImpl(key);
    }

    default public String name() {
        return this.key().asString();
    }
}

