/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ServerProcess;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.registry.RegistryKeyImpl;
import net.minestom.server.registry.RegistryTag;
import net.minestom.server.registry.TagKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

final class RegistryTagImpl {
    RegistryTagImpl() {
    }

    record Direct<T>(List<RegistryKey<T>> keys) implements RegistryTag<T>
    {
        public Direct {
            keys = List.copyOf(keys);
        }

        @Override
        @Nullable
        public TagKey<T> key() {
            return null;
        }

        @Override
        public boolean contains(RegistryKey<T> value) {
            RegistryKeyImpl registryKeyImpl;
            if (value instanceof RegistryKeyImpl) {
                RegistryKeyImpl key = (RegistryKeyImpl)value;
                registryKeyImpl = key;
            } else {
                registryKeyImpl = new RegistryKeyImpl(value.key());
            }
            return this.keys.contains(registryKeyImpl);
        }

        @Override
        public Iterator<RegistryKey<T>> iterator() {
            return this.keys.iterator();
        }

        @Override
        public int size() {
            return this.keys.size();
        }
    }

    static final class Backed<T>
    implements RegistryTag<T> {
        private final TagKey<T> key;
        private final Set<RegistryKey<T>> entries = new CopyOnWriteArraySet<RegistryKey<T>>();

        Backed(TagKey<T> key) {
            this.key = key;
        }

        @Override
        public TagKey<T> key() {
            return this.key;
        }

        @Override
        public boolean contains(RegistryKey<T> value) {
            RegistryKeyImpl registryKeyImpl;
            if (value instanceof RegistryKeyImpl) {
                RegistryKeyImpl key = (RegistryKeyImpl)value;
                registryKeyImpl = key;
            } else {
                registryKeyImpl = new RegistryKeyImpl(value.key());
            }
            return this.entries.contains(registryKeyImpl);
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        @Override
        public Iterator<RegistryKey<T>> iterator() {
            return this.entries.iterator();
        }

        @ApiStatus.Internal
        void add(RegistryKey<T> key) {
            if (this.entries.add(key)) {
                this.invalidate();
            }
        }

        @ApiStatus.Internal
        void remove(RegistryKey<T> key) {
            if (this.entries.remove(key)) {
                this.invalidate();
            }
        }

        private void invalidate() {
            ServerProcess process = MinecraftServer.process();
            if (process == null) {
                return;
            }
            process.connection().invalidateTags();
        }
    }

    record Empty() implements RegistryTag<Object>
    {
        public static final Empty INSTANCE = new Empty();

        @Override
        @Nullable
        public TagKey<Object> key() {
            return null;
        }

        @Override
        public boolean contains(RegistryKey<Object> value) {
            return false;
        }

        @Override
        public Iterator<RegistryKey<Object>> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }
    }
}

