/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.thread;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import net.minestom.server.MinecraftServer;
import net.minestom.server.Tickable;
import net.minestom.server.thread.AcquirableSource;
import net.minestom.server.thread.MinestomThread;
import net.minestom.server.thread.ThreadDispatcherImpl;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class TickThread
extends MinestomThread {
    private final ReentrantLock lock = new ReentrantLock();
    private volatile boolean stop;
    private final AtomicReference<CountDownLatch> latchRef = new AtomicReference();
    private volatile long tickTimeNanos;
    private long tickNum = 0L;
    final List<ThreadDispatcherImpl.Partition> entries = new ArrayList<ThreadDispatcherImpl.Partition>();

    public TickThread(int number) {
        super("Ms-Tick-" + number);
    }

    public TickThread(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LockSupport.park(this);
        while (!this.stop) {
            CountDownLatch latch = this.latchRef.get();
            if (latch == null) {
                LockSupport.park(this);
                continue;
            }
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                this.tick();
            }
            catch (Exception e) {
                MinecraftServer.getExceptionManager().handleException(e);
            }
            finally {
                lock.unlock();
            }
            this.latchRef.set(null);
            latch.countDown();
            LockSupport.park(this);
        }
    }

    protected void tick() {
        ReentrantLock lock = this.lock;
        long tickTime = TimeUnit.NANOSECONDS.toMillis(this.tickTimeNanos);
        for (ThreadDispatcherImpl.Partition entry : this.entries) {
            assert (entry.thread() == this);
            List<Tickable> elements = entry.elements();
            if (elements.isEmpty()) continue;
            for (Tickable element : elements) {
                if (lock.hasQueuedThreads()) {
                    lock.unlock();
                    lock.lock();
                }
                try {
                    assert (this.assertElement(element));
                    element.tick(tickTime);
                }
                catch (Throwable e) {
                    MinecraftServer.getExceptionManager().handleException(e);
                }
            }
        }
    }

    private boolean assertElement(Tickable element) {
        AcquirableSource source;
        return !(element instanceof AcquirableSource) || (source = (AcquirableSource)((Object)element)).acquirable().assignedThread() == this && source.acquirable().assignedThread().lock().isHeldByCurrentThread();
    }

    void startTick(CountDownLatch latch, long tickTimeNanos) {
        CountDownLatch update = this.latchRef.updateAndGet(prevLatch -> prevLatch == null || prevLatch.getCount() == 0L ? latch : prevLatch);
        if (update != latch) {
            try {
                update.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.startTick(latch, tickTimeNanos);
            return;
        }
        if (this.stop || this.entries.isEmpty()) {
            latch.countDown();
            return;
        }
        this.tickTimeNanos = tickTimeNanos;
        ++this.tickNum;
        LockSupport.unpark(this);
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public long getTick() {
        return this.tickNum;
    }

    void shutdown() {
        this.stop = true;
        LockSupport.unpark(this);
    }
}

