/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import java.lang.ref.Cleaner;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpmcUnboundedXaddArrayQueue;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@ApiStatus.Experimental
public final class ObjectPool<T> {
    private static final int QUEUE_SIZE = 32768;
    private static final Cleaner CLEANER = Cleaner.create();
    private final MessagePassingQueue<SoftReference<T>> pool = new MpmcUnboundedXaddArrayQueue<SoftReference<T>>(32768);
    private final Supplier<T> supplier;
    private final UnaryOperator<T> sanitizer;

    public static <T> ObjectPool<T> pool(Supplier<T> supplier, UnaryOperator<T> sanitizer) {
        return new ObjectPool<T>(supplier, sanitizer);
    }

    public static <T> ObjectPool<T> pool(Supplier<T> supplier) {
        return new ObjectPool<T>(supplier, UnaryOperator.identity());
    }

    private ObjectPool(Supplier<T> supplier, UnaryOperator<T> sanitizer) {
        this.supplier = supplier;
        this.sanitizer = sanitizer;
    }

    public T get() {
        SoftReference<T> ref;
        while ((ref = this.pool.poll()) != null) {
            T result = ref.get();
            if (result == null) continue;
            return result;
        }
        return this.supplier.get();
    }

    public T getAndRegister(Object ref) {
        T result = this.get();
        this.register(ref, result);
        return result;
    }

    public void add(T object) {
        object = this.sanitizer.apply(object);
        this.pool.offer(new SoftReference<T>(object));
    }

    public void clear() {
        this.pool.clear();
    }

    public int count() {
        return this.pool.size();
    }

    public void register(Object ref, AtomicReference<T> objectRef) {
        CLEANER.register(ref, new BufferRefCleaner<T>(this, objectRef));
    }

    public void register(Object ref, T object) {
        CLEANER.register(ref, new BufferCleaner<T>(this, object));
    }

    public void register(Object ref, Collection<T> objects) {
        CLEANER.register(ref, new BuffersCleaner<T>(this, objects));
    }

    public Holder hold() {
        return new Holder(this, this.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R use(Function<T, R> function) {
        T object = this.get();
        try {
            R r = function.apply(object);
            return r;
        }
        finally {
            this.add(object);
        }
    }

    private record BufferRefCleaner<T>(ObjectPool<T> pool, AtomicReference<T> objectRef) implements Runnable
    {
        @Override
        public void run() {
            this.pool.add(this.objectRef.get());
        }
    }

    private record BufferCleaner<T>(ObjectPool<T> pool, T object) implements Runnable
    {
        @Override
        public void run() {
            this.pool.add(this.object);
        }
    }

    private record BuffersCleaner<T>(ObjectPool<T> pool, Collection<T> objects) implements Runnable
    {
        @Override
        public void run() {
            for (T buffer : this.objects) {
                this.pool.add(buffer);
            }
        }
    }

    public final class Holder
    implements AutoCloseable {
        private final T object;
        private final AtomicBoolean closed;
        final /* synthetic */ ObjectPool this$0;

        Holder(ObjectPool this$0, T object) {
            ObjectPool objectPool = this$0;
            Objects.requireNonNull(objectPool);
            this.this$0 = objectPool;
            this.closed = new AtomicBoolean(false);
            this.object = object;
        }

        public T get() {
            if (this.closed.get()) {
                throw new IllegalStateException("Holder is closed");
            }
            return this.object;
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                this.this$0.add(this.object);
            }
        }
    }
}

