/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.async;

import java.util.concurrent.CompletableFuture;
import net.minestom.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class AsyncUtils {
    public static final CompletableFuture<Void> VOID_FUTURE = CompletableFuture.completedFuture(null);

    public static <T> CompletableFuture<T> empty() {
        return VOID_FUTURE;
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable) {
        return CompletableFuture.runAsync(() -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                MinecraftServer.getExceptionManager().handleException(e);
            }
        });
    }
}

