/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.block;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;

public class BlockIterator
implements Iterator<Point> {
    private final short[] signums = new short[3];
    private Vec end;
    private boolean smooth;
    private boolean foundEnd = false;
    double sideDistX;
    double sideDistY;
    double sideDistZ;
    private double deltaDistX;
    private double deltaDistY;
    private double deltaDistZ;
    int mapX;
    int mapY;
    int mapZ;
    private final ArrayDeque<Point> extraPoints = new ArrayDeque();

    public BlockIterator(Vec start, Vec direction, double yOffset, double maxDistance, boolean smooth) {
        this.reset(start, direction, yOffset, maxDistance, smooth);
    }

    public BlockIterator() {
    }

    public void reset(Vec start, Vec direction, double yOffset, double maxDistance, boolean smooth) {
        this.extraPoints.clear();
        this.foundEnd = false;
        start = start.add(0.0, yOffset, 0.0);
        this.end = maxDistance != 0.0 ? start.add(direction.normalize().mul(maxDistance)) : null;
        if (direction.isZero()) {
            this.foundEnd = true;
        }
        this.smooth = smooth;
        Vec ray = direction.normalize();
        this.mapX = start.blockX();
        this.mapY = start.blockY();
        this.mapZ = start.blockZ();
        this.signums[0] = (short)Math.signum(direction.x());
        this.signums[1] = (short)Math.signum(direction.y());
        this.signums[2] = (short)Math.signum(direction.z());
        this.deltaDistX = ray.x() == 0.0 ? 1.0E30 : Math.abs(1.0 / ray.x());
        this.deltaDistY = ray.y() == 0.0 ? 1.0E30 : Math.abs(1.0 / ray.y());
        double d = this.deltaDistZ = ray.z() == 0.0 ? 1.0E30 : Math.abs(1.0 / ray.z());
        this.sideDistX = ray.x() < 0.0 ? (start.x() - (double)this.mapX) * this.deltaDistX : (ray.x() > 0.0 ? ((double)(this.mapX + this.signums[0]) - start.x()) * this.deltaDistX : Double.MAX_VALUE);
        this.sideDistY = ray.y() < 0.0 ? (start.y() - (double)this.mapY) * this.deltaDistY : (ray.y() > 0.0 ? ((double)(this.mapY + this.signums[1]) - start.y()) * this.deltaDistY : Double.MAX_VALUE);
        this.sideDistZ = ray.z() < 0.0 ? (start.z() - (double)this.mapZ) * this.deltaDistZ : (ray.z() > 0.0 ? ((double)(this.mapZ + this.signums[2]) - start.z()) * this.deltaDistZ : Double.MAX_VALUE);
    }

    public BlockIterator(Vec start, Vec direction, double yOffset, double maxDistance) {
        this(start, direction, yOffset, maxDistance, false);
    }

    public BlockIterator(Pos pos, double yOffset, int maxDistance) {
        this(pos.asVec(), pos.direction(), yOffset, maxDistance, false);
    }

    public BlockIterator(Pos pos, double yOffset) {
        this(pos.asVec(), pos.direction(), yOffset, 0.0, false);
    }

    public BlockIterator(Pos pos) {
        this(pos, 0.0);
    }

    public BlockIterator(Entity entity, int maxDistance) {
        this(entity.getPosition(), entity.getEyeHeight(), maxDistance);
    }

    public BlockIterator(Entity entity) {
        this(entity, 0);
    }

    @Override
    public boolean hasNext() {
        return !this.foundEnd;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("[BlockIterator] doesn't support block removal");
    }

    @Override
    public Point next() {
        boolean needsZ;
        double closest;
        if (this.foundEnd) {
            throw new NoSuchElementException();
        }
        if (!this.extraPoints.isEmpty()) {
            Point res = this.extraPoints.poll();
            if (this.end != null && res.sameBlock(this.end)) {
                this.foundEnd = true;
            }
            return res;
        }
        Vec current = new Vec(this.mapX, this.mapY, this.mapZ);
        if (this.end != null && current.sameBlock(this.end)) {
            this.foundEnd = true;
        }
        boolean needsX = this.sideDistX - (closest = Math.min(this.sideDistX, Math.min(this.sideDistY, this.sideDistZ))) < 1.0E-10 && this.signums[0] != 0;
        boolean needsY = this.sideDistY - closest < 1.0E-10 && this.signums[1] != 0;
        boolean bl = needsZ = this.sideDistZ - closest < 1.0E-10 && this.signums[2] != 0;
        if (needsZ) {
            this.sideDistZ += this.deltaDistZ;
            this.mapZ += this.signums[2];
        }
        if (needsX) {
            this.sideDistX += this.deltaDistX;
            this.mapX += this.signums[0];
        }
        if (needsY) {
            this.sideDistY += this.deltaDistY;
            this.mapY += this.signums[1];
        }
        if (needsX && needsY && needsZ) {
            this.extraPoints.add(new Vec((double)this.signums[0] + current.x(), (double)this.signums[1] + current.y(), current.z()));
            if (this.smooth) {
                return current;
            }
            this.extraPoints.add(new Vec(current.x(), (double)this.signums[1] + current.y(), (double)this.signums[2] + current.z()));
            this.extraPoints.add(new Vec((double)this.signums[0] + current.x(), current.y(), (double)this.signums[2] + current.z()));
            this.extraPoints.add(new Vec((double)this.signums[0] + current.x(), current.y(), current.z()));
            this.extraPoints.add(new Vec(current.x(), (double)this.signums[1] + current.y(), current.z()));
            this.extraPoints.add(new Vec(current.x(), current.y(), (double)this.signums[2] + current.z()));
        } else if (needsX && needsY) {
            this.extraPoints.add(new Vec((double)this.signums[0] + current.x(), current.y(), current.z()));
            if (this.smooth) {
                return current;
            }
            this.extraPoints.add(new Vec(current.x(), (double)this.signums[1] + current.y(), current.z()));
        } else if (needsX && needsZ) {
            this.extraPoints.add(new Vec((double)this.signums[0] + current.x(), current.y(), current.z()));
            if (this.smooth) {
                return current;
            }
            this.extraPoints.add(new Vec(current.x(), current.y(), (double)this.signums[2] + current.z()));
        } else if (needsY && needsZ) {
            this.extraPoints.add(new Vec(current.x(), (double)this.signums[1] + current.y(), current.z()));
            if (this.smooth) {
                return current;
            }
            this.extraPoints.add(new Vec(current.x(), current.y(), (double)this.signums[2] + current.z()));
        }
        return current;
    }
}

