/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record MappedCollection<O, R>(Collection<O> original, Function<O, R> mapper) implements Collection<R>
{
    public static <O extends AtomicReference<R>, R> MappedCollection<O, R> plainReferences(Collection<O> original) {
        return new MappedCollection<AtomicReference, Object>(original, AtomicReference::getPlain);
    }

    @Override
    public int size() {
        return this.original.size();
    }

    @Override
    public boolean isEmpty() {
        return this.original.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        for (O entry : this.original) {
            if (!this.mapper.apply(entry).equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<R> iterator() {
        final Iterator<O> iterator = this.original.iterator();
        return new Iterator<R>(this){
            final /* synthetic */ MappedCollection this$0;
            {
                MappedCollection mappedCollection = this$0;
                Objects.requireNonNull(mappedCollection);
                this.this$0 = mappedCollection;
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public R next() {
                return this.this$0.mapper.apply(iterator.next());
            }
        };
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("Unsupported array object");
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException("Unsupported array generic");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c.size() > this.original.size()) {
            return false;
        }
        for (Object entry : c) {
            if (this.contains(entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(R t) {
        throw new UnsupportedOperationException("Unmodifiable collection");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Unmodifiable collection");
    }

    @Override
    public boolean addAll(Collection<? extends R> c) {
        throw new UnsupportedOperationException("Unmodifiable collection");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Unmodifiable collection");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Unmodifiable collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Unmodifiable collection");
    }
}

