/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.location;

import java.util.Objects;
import net.minestom.server.command.CommandSender;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Player;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.Nullable;

public record RelativeVec(Vec vec, CoordinateType coordinateType, boolean relativeX, boolean relativeY, boolean relativeZ) {
    public RelativeVec {
        Check.argCondition(relativeX && coordinateType == CoordinateType.ABSOLUTE, "RelativeVec `x` cannot have relativity while coordinateType is absolute.");
        Check.argCondition(relativeY && coordinateType == CoordinateType.ABSOLUTE, "RelativeVec `y` cannot have relativity while coordinateType is absolute.");
        Check.argCondition(relativeZ && coordinateType == CoordinateType.ABSOLUTE, "RelativeVec `z` cannot have relativity while coordinateType is absolute.");
        Check.argCondition(coordinateType == CoordinateType.LOCAL && (!relativeX || !relativeY && vec.y() != 0.0 || !relativeZ), "RelativeVec is always relative while coordinateType is local.");
    }

    public Vec from(@Nullable Pos origin) {
        origin = Objects.requireNonNullElse(origin, Pos.ZERO);
        return this.coordinateType.convert(this.vec, origin, this.relativeX, this.relativeY, this.relativeZ);
    }

    public Vec from(@Nullable Entity entity) {
        if (entity != null) {
            return this.from(entity.getPosition());
        }
        return this.from(Pos.ZERO);
    }

    public Vec fromSender(@Nullable CommandSender sender) {
        Pos entityPosition = sender instanceof Player ? ((Player)sender).getPosition() : Pos.ZERO;
        return this.from(entityPosition);
    }

    public Vec fromView(@Nullable Pos point) {
        if (!(this.relativeX || this.relativeY || this.relativeZ)) {
            return this.vec;
        }
        Pos absolute = Objects.requireNonNullElse(point, Pos.ZERO);
        double x = this.vec.x() + (double)(this.relativeX ? absolute.yaw() : 0.0f);
        double z = this.vec.z() + (double)(this.relativeZ ? absolute.pitch() : 0.0f);
        return new Vec(x, 0.0, z);
    }

    public Vec fromView(@Nullable Entity entity) {
        Pos entityPosition = entity != null ? entity.getPosition() : Pos.ZERO;
        return this.fromView(entityPosition);
    }

    public boolean isRelativeX() {
        return this.relativeX;
    }

    public boolean isRelativeY() {
        return this.relativeY;
    }

    public boolean isRelativeZ() {
        return this.relativeZ;
    }

    public static enum CoordinateType {
        RELATIVE((relative, origin, relativeX, relativeY, relativeZ) -> {
            Record absolute = Objects.requireNonNullElse(origin, Vec.ZERO);
            double x = relative.x() + (relativeX ? ((Point)((Object)absolute)).x() : 0.0);
            double y = relative.y() + (relativeY ? ((Point)((Object)absolute)).y() : 0.0);
            double z = relative.z() + (relativeZ ? ((Point)((Object)absolute)).z() : 0.0);
            return new Vec(x, y, z);
        }),
        LOCAL((local, origin, relativeX, relativeY, relativeZ) -> {
            Vec vec1 = new Vec(Math.cos(Math.toRadians(origin.yaw() + 90.0f)), 0.0, Math.sin(Math.toRadians(origin.yaw() + 90.0f)));
            Vec a = vec1.mul(Math.cos(Math.toRadians(-origin.pitch()))).withY(Math.sin(Math.toRadians(-origin.pitch())));
            Vec b = vec1.mul(Math.cos(Math.toRadians(-origin.pitch() + 90.0f))).withY(Math.sin(Math.toRadians(-origin.pitch() + 90.0f)));
            Vec c = a.cross(b).neg();
            Vec relativePos = a.mul(local.z()).add(b.mul(local.y())).add(c.mul(local.x()));
            return origin.add(relativePos).asVec();
        }),
        ABSOLUTE((vec, origin, relativeX1, relativeY1, relativeZ1) -> vec);

        private final CoordinateConverter converter;

        private CoordinateType(CoordinateConverter converter) {
            this.converter = converter;
        }

        private Vec convert(Vec vec, Pos origin, boolean relativeX, boolean relativeY, boolean relativeZ) {
            return this.converter.convert(vec, origin, relativeX, relativeY, relativeZ);
        }
    }

    @FunctionalInterface
    private static interface CoordinateConverter {
        public Vec convert(Vec var1, Pos var2, boolean var3, boolean var4, boolean var5);
    }
}

