/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.mojang;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minestom.server.ServerFlag;
import net.minestom.server.utils.url.URLUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.Nullable;

public final class MojangUtils {
    private static final String FROM_UUID_URL = "https://sessionserver.mojang.com/session/minecraft/profile/%s?unsigned=false";
    private static final String FROM_USERNAME_URL = "https://api.minecraftservices.com/minecraft/profile/lookup/name/%s";
    private static final String BASE_AUTH_URL = ServerFlag.AUTH_URL.concat("?username=%s&serverId=%s");
    private static final String PREVENT_PROXY_CONNECTIONS_AUTH_URL = BASE_AUTH_URL.concat("&ip=%s");

    @Blocking
    public static UUID getUUID(String username) throws IOException {
        return UUID.fromString(MojangUtils.retrieve(String.format(FROM_USERNAME_URL, username)).get("id").getAsString().replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5"));
    }

    @Blocking
    public static String getUsername(UUID playerUUID) throws IOException {
        return MojangUtils.retrieve(String.format(FROM_UUID_URL, playerUUID)).get("name").getAsString();
    }

    @Blocking
    @Nullable
    public static JsonObject fromUuid(UUID uuid) {
        return MojangUtils.fromUuid(uuid.toString());
    }

    @Blocking
    @Nullable
    public static JsonObject fromUuid(String uuid) {
        try {
            return MojangUtils.retrieve(String.format(FROM_UUID_URL, uuid));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Blocking
    @Nullable
    public static JsonObject fromUsername(String username) {
        try {
            return MojangUtils.retrieve(String.format(FROM_USERNAME_URL, username));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Blocking
    @ApiStatus.Internal
    public static JsonObject authenticateSession(String loginUsername, String serverId, @Nullable SocketAddress userSocket) throws IOException {
        String url;
        InetSocketAddress inetSocketAddress;
        InetAddress inetAddress;
        String username = URLEncoder.encode(loginUsername, StandardCharsets.UTF_8);
        if (ServerFlag.AUTH_PREVENT_PROXY_CONNECTIONS && userSocket instanceof InetSocketAddress && (inetAddress = (inetSocketAddress = (InetSocketAddress)userSocket).getAddress()) instanceof InetAddress) {
            InetAddress address = inetAddress;
            url = String.format(PREVENT_PROXY_CONNECTIONS_AUTH_URL, username, serverId, address.getHostAddress());
        } else {
            url = String.format(BASE_AUTH_URL, username, serverId);
        }
        return MojangUtils.retrieve(url);
    }

    private static JsonObject retrieve(String url) throws IOException {
        String response = URLUtils.getText(url);
        if (response.isEmpty()) {
            throw new IOException("The Mojang API is down");
        }
        JsonObject jsonObject = JsonParser.parseString(response).getAsJsonObject();
        if (jsonObject.has("errorMessage")) {
            throw new IOException(jsonObject.get("errorMessage").getAsString());
        }
        return jsonObject;
    }
}

