/*
 * Decompiled with CFR 0.152.
 */
package net.hollowcube.polar;

import com.github.luben.zstd.Zstd;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.Objects;
import net.hollowcube.polar.PaletteUtil;
import net.hollowcube.polar.PolarChunk;
import net.hollowcube.polar.PolarDataConverter;
import net.hollowcube.polar.PolarLoader;
import net.hollowcube.polar.PolarReader;
import net.hollowcube.polar.PolarSection;
import net.hollowcube.polar.PolarWorld;
import net.hollowcube.polar.PolarWorldAccess;
import net.hollowcube.polar.UnsafeOps;
import net.minestom.server.MinecraftServer;
import net.minestom.server.command.builder.arguments.minecraft.ArgumentBlockState;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import net.minestom.server.coordinate.CoordConversion;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.InstanceContainer;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.block.Block;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.PolarBufferAccessWidener;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StreamingPolarLoader {
    private final InstanceContainer instance;
    private final PolarDataConverter dataConverter;
    private final PolarWorldAccess worldAccess;
    private final boolean loadLighting;
    private int version;
    private int dataVersion;
    private final Object2IntMap<String> blockToStateIdCache = new Object2IntOpenHashMap<String>();
    private final Object2IntMap<String> biomeToIdCache = new Object2IntOpenHashMap<String>();
    private final int plainsBiomeId;
    private static final NetworkBuffer.Type<String[]> STRING_ARRAY = new NetworkBuffer.Type<String[]>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, String[] value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] read(@NotNull NetworkBuffer buffer) {
            String[] array = new String[buffer.read(NetworkBuffer.VAR_INT).intValue()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = buffer.read(NetworkBuffer.STRING);
            }
            return array;
        }
    };

    StreamingPolarLoader(@NotNull InstanceContainer instance, @NotNull PolarDataConverter dataConverter, @Nullable PolarWorldAccess worldAccess, boolean loadLighting) {
        this.instance = instance;
        this.dataConverter = dataConverter;
        this.worldAccess = worldAccess;
        this.loadLighting = loadLighting;
        PolarWorldAccess searchWorldAccess = Objects.requireNonNullElse(worldAccess, PolarWorldAccess.DEFAULT);
        this.plainsBiomeId = searchWorldAccess.getBiomeId(Biome.PLAINS.name());
        if (this.plainsBiomeId == -1) {
            throw new IllegalStateException("Plains biome not found");
        }
    }

    public void loadAllSequential(@NotNull ReadableByteChannel channel, long fileSize) throws IOException {
        byte maxSection;
        NetworkBuffer buffer = this.readHeader(channel, fileSize);
        byte minSection = buffer.read(NetworkBuffer.BYTE);
        PolarReader.assertThat(minSection < (maxSection = buffer.read(NetworkBuffer.BYTE).byteValue()), "Invalid section range");
        if (this.version > 4) {
            int userDataLength = buffer.read(NetworkBuffer.VAR_INT);
            if (this.worldAccess != null) {
                NetworkBuffer worldDataView = PolarBufferAccessWidener.networkBufferView(buffer, buffer.readIndex(), userDataLength);
                this.worldAccess.loadWorldData(this.instance, worldDataView);
            }
            buffer.advanceRead(userDataLength);
        }
        int chunkCount = buffer.read(NetworkBuffer.VAR_INT);
        for (int i = 0; i < chunkCount; ++i) {
            this.readChunk(buffer, minSection, maxSection);
        }
        Check.stateCondition(buffer.readableBytes() > 0L, "Unexpected extra data at end of buffer");
    }

    private NetworkBuffer readHeader(@NotNull ReadableByteChannel channel, long fileSize) throws IOException {
        NetworkBuffer buffer = NetworkBuffer.staticBuffer(fileSize, MinecraftServer.process());
        buffer.readChannel(channel);
        Integer magicNumber = buffer.read(NetworkBuffer.INT);
        PolarReader.assertThat(magicNumber == 1349479538, "Invalid magic number");
        this.version = buffer.read(NetworkBuffer.SHORT).shortValue();
        PolarReader.validateVersion(this.version);
        this.dataVersion = this.version >= 6 ? buffer.read(NetworkBuffer.VAR_INT).intValue() : this.dataConverter.defaultDataVersion();
        PolarWorld.CompressionType compression = PolarWorld.CompressionType.fromId(buffer.read(NetworkBuffer.BYTE).byteValue());
        PolarReader.assertThat(compression != null, "Invalid compression type");
        Integer compressedDataLength = buffer.read(NetworkBuffer.VAR_INT);
        return switch (compression) {
            default -> throw new MatchException(null, null);
            case PolarWorld.CompressionType.NONE -> buffer;
            case PolarWorld.CompressionType.ZSTD -> {
                NetworkBuffer dst = NetworkBuffer.staticBuffer(compressedDataLength.intValue(), MinecraftServer.process());
                long srcAddress = PolarBufferAccessWidener.networkBufferAddress(buffer) + buffer.readIndex();
                long dstAddress = PolarBufferAccessWidener.networkBufferAddress(dst);
                long count = Zstd.decompressUnsafe(dstAddress, compressedDataLength.intValue(), srcAddress, buffer.readableBytes());
                if (Zstd.isError(count)) {
                    throw new RuntimeException("decompression failed: " + Zstd.getErrorName(count));
                }
                dst.writeIndex(compressedDataLength.intValue());
                yield dst;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readChunk(@NotNull NetworkBuffer buffer, int minSection, int maxSection) {
        Integer chunkX = buffer.read(NetworkBuffer.VAR_INT);
        Integer chunkZ = buffer.read(NetworkBuffer.VAR_INT);
        Chunk chunk = this.instance.getChunkSupplier().createChunk(this.instance, chunkX, chunkZ);
        UnsafeOps.unsafeSetNeedsCompleteHeightmapRefresh(chunk, false);
        Int2ObjectOpenHashMap<Block> chunkEntries = UnsafeOps.unsafeGetEntries(chunk);
        Int2ObjectOpenHashMap<Block> chunkTickables = UnsafeOps.unsafeGetTickableMap(chunk);
        Chunk chunk2 = chunk;
        synchronized (chunk2) {
            for (int sectionY = minSection; sectionY <= maxSection; ++sectionY) {
                this.readSection(buffer, chunk.getSection(sectionY));
            }
            int blockEntityCount = buffer.read(NetworkBuffer.VAR_INT);
            for (int i = 0; i < blockEntityCount; ++i) {
                PolarChunk.BlockEntity blockEntity = PolarReader.readBlockEntity(this.dataConverter, this.version, this.dataVersion, buffer);
                if (chunkEntries != null && chunkTickables != null) {
                    Block block = PolarLoader.createBlockEntity(chunk, blockEntity);
                    int index = CoordConversion.chunkBlockIndex(blockEntity.x(), blockEntity.y(), blockEntity.z());
                    chunkEntries.put(index, block);
                    if (block.handler() == null || !block.handler().isTickable()) continue;
                    chunkTickables.put(index, block);
                    continue;
                }
                PolarLoader.loadBlockEntity(chunk, blockEntity);
            }
            int[][] heightmaps = PolarReader.readHeightmapData(buffer, this.worldAccess == null);
            if (this.worldAccess != null) {
                this.worldAccess.loadHeightmaps(chunk, heightmaps);
            } else {
                UnsafeOps.unsafeSetNeedsCompleteHeightmapRefresh(chunk, true);
            }
        }
        UnsafeOps.unsafeCacheChunk(this.instance, chunk);
        if (this.version > 2) {
            int userDataLength = buffer.read(NetworkBuffer.VAR_INT);
            if (this.worldAccess != null) {
                NetworkBuffer chunkDataView = PolarBufferAccessWidener.networkBufferView(buffer, buffer.readIndex(), userDataLength);
                this.worldAccess.loadChunkData(chunk, chunkDataView);
            }
            buffer.advanceRead(userDataLength);
        }
    }

    private void readSection(@NotNull NetworkBuffer buffer, @NotNull Section section) {
        int[] biomePalette;
        if (buffer.read(NetworkBuffer.BOOLEAN).booleanValue()) {
            return;
        }
        int[] blockPalette = this.readBlockPalette(buffer);
        if (blockPalette.length == 1) {
            if (blockPalette[0] != 0) {
                section.blockPalette().fill(blockPalette[0]);
            }
        } else {
            int[] blockData = new int[4096];
            long[] rawBlockData = buffer.read(NetworkBuffer.LONG_ARRAY);
            int bitsPerEntry = (int)Math.ceil(Math.log(blockPalette.length) / Math.log(2.0));
            PaletteUtil.unpack(blockData, rawBlockData, bitsPerEntry);
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        int index = y * 16 * 16 + z * 16 + x;
                        section.blockPalette().set(x, y, z, blockPalette[blockData[index]]);
                    }
                }
            }
        }
        if ((biomePalette = this.readBiomePalette(buffer)).length == 1) {
            section.biomePalette().fill(biomePalette[0]);
        } else {
            int[] biomeData = new int[64];
            long[] rawBiomeData = buffer.read(NetworkBuffer.LONG_ARRAY);
            int bitsPerEntry = (int)Math.ceil(Math.log(biomePalette.length) / Math.log(2.0));
            PaletteUtil.unpack(biomeData, rawBiomeData, bitsPerEntry);
            for (int y = 0; y < 4; ++y) {
                for (int z = 0; z < 4; ++z) {
                    for (int x = 0; x < 4; ++x) {
                        int index = x + z * 4 + y * 16;
                        section.biomePalette().set(x, y, z, biomePalette[biomeData[index]]);
                    }
                }
            }
        }
        if (this.version > 1) {
            byte[] skyLight;
            byte[] blockLight;
            PolarSection.LightContent blockLightContent = this.version >= 7 ? PolarSection.LightContent.VALUES[buffer.read(NetworkBuffer.BYTE)] : (buffer.read(NetworkBuffer.BOOLEAN) != false ? PolarSection.LightContent.PRESENT : PolarSection.LightContent.MISSING);
            byte[] byArray = blockLight = blockLightContent == PolarSection.LightContent.PRESENT ? buffer.read(PolarReader.LIGHT_DATA) : null;
            if (this.loadLighting && blockLightContent != PolarSection.LightContent.MISSING) {
                section.setBlockLight(PolarLoader.getLightArray(blockLightContent, blockLight));
            }
            PolarSection.LightContent skyLightContent = this.version >= 7 ? PolarSection.LightContent.VALUES[buffer.read(NetworkBuffer.BYTE)] : (buffer.read(NetworkBuffer.BOOLEAN) != false ? PolarSection.LightContent.PRESENT : PolarSection.LightContent.MISSING);
            byte[] byArray2 = skyLight = skyLightContent == PolarSection.LightContent.PRESENT ? buffer.read(PolarReader.LIGHT_DATA) : null;
            if (this.loadLighting && skyLightContent != PolarSection.LightContent.MISSING) {
                section.setSkyLight(PolarLoader.getLightArray(skyLightContent, skyLight));
            }
        } else if (buffer.read(NetworkBuffer.BOOLEAN).booleanValue()) {
            if (this.loadLighting) {
                section.setBlockLight(buffer.read(PolarReader.LIGHT_DATA));
                section.setSkyLight(buffer.read(PolarReader.LIGHT_DATA));
            } else {
                buffer.advanceRead(4096L);
            }
        }
    }

    private int[] readBlockPalette(@NotNull NetworkBuffer buffer) {
        String[] rawBlockPalette = buffer.read(STRING_ARRAY);
        if (this.dataVersion < this.dataConverter.dataVersion()) {
            this.dataConverter.convertBlockPalette(rawBlockPalette, this.dataVersion, this.dataConverter.dataVersion());
        }
        PolarReader.upgradeGrassInPalette(rawBlockPalette, this.version);
        int[] blockPalette = new int[rawBlockPalette.length];
        for (int i = 0; i < rawBlockPalette.length; ++i) {
            blockPalette[i] = this.blockToStateIdCache.computeIfAbsent(rawBlockPalette[i], key -> {
                try {
                    return ArgumentBlockState.staticParse(key).stateId();
                }
                catch (ArgumentSyntaxException e) {
                    throw new RuntimeException("Failed to parse block state: " + key, e);
                }
            });
        }
        return blockPalette;
    }

    private int[] readBiomePalette(@NotNull NetworkBuffer buffer) {
        String[] rawBiomePalette = buffer.read(STRING_ARRAY);
        int[] biomePalette = new int[rawBiomePalette.length];
        for (int i = 0; i < rawBiomePalette.length; ++i) {
            biomePalette[i] = this.biomeToIdCache.computeIfAbsent(rawBiomePalette[i], name -> {
                PolarWorldAccess searchWorldAccess = Objects.requireNonNullElse(this.worldAccess, PolarWorldAccess.DEFAULT);
                int biomeId = searchWorldAccess.getBiomeId((String)name);
                if (biomeId == -1) {
                    PolarLoader.logger.error("Failed to find biome: {}", name);
                    biomeId = this.plainsBiomeId;
                }
                return biomeId;
            });
        }
        return biomePalette;
    }

    private int computeCount(int[] palette, long[] rawData, int bitsPerEntry) {
        int zeroIndex = -1;
        for (int i = 0; i < palette.length; ++i) {
            if (palette[i] != 0) continue;
            zeroIndex = i;
            break;
        }
        int count = 0;
        double intsPerLong = Math.floor(64.0 / (double)bitsPerEntry);
        int intsPerLongCeil = (int)Math.ceil(intsPerLong);
        long mask = (1L << bitsPerEntry) - 1L;
        for (int i = 0; i < 4096; ++i) {
            int longIndex = i / intsPerLongCeil;
            int subIndex = i % intsPerLongCeil;
            int index = (int)(rawData[longIndex] >>> bitsPerEntry * subIndex & mask);
            if (index == zeroIndex) continue;
            ++count;
        }
        return count;
    }
}

