/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.dialog;

import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.dialog.DialogActionButton;
import net.minestom.server.dialog.DialogMetadata;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Holder;
import net.minestom.server.registry.HolderSet;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.RegistryData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface Dialog
extends Holder.Direct<Dialog> {
    @NotNull
    public static final Registry<StructCodec<? extends Dialog>> REGISTRY = DynamicRegistry.fromMap(Key.key("minecraft:dialog_type"), Map.entry(Key.key("notice"), Notice.CODEC), Map.entry(Key.key("server_links"), ServerLinks.CODEC), Map.entry(Key.key("dialog_list"), DialogList.CODEC), Map.entry(Key.key("multi_action"), MultiAction.CODEC), Map.entry(Key.key("confirmation"), Confirmation.CODEC));
    @NotNull
    public static final Codec<Dialog> REGISTRY_CODEC = Codec.RegistryTaggedUnion(REGISTRY, Dialog::codec, "type");
    @NotNull
    public static final NetworkBuffer.Type<Dialog> REGISTRY_NETWORK_TYPE = NetworkBuffer.TypedNBT(REGISTRY_CODEC);
    @NotNull
    public static final NetworkBuffer.Type<Holder<Dialog>> NETWORK_TYPE = Holder.networkType(Registries::dialog, REGISTRY_NETWORK_TYPE);
    @NotNull
    public static final Codec<Holder<Dialog>> CODEC = Holder.codec(Registries::dialog, REGISTRY_CODEC);

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<Dialog> createDefaultRegistry(@NotNull Registries registries) {
        return DynamicRegistry.createForDialogWithSelfReferentialLoadingNightmare(Key.key("minecraft:dialog"), REGISTRY_CODEC, RegistryData.Resource.DIALOGS, registries);
    }

    @NotNull
    public DialogMetadata metadata();

    @NotNull
    public StructCodec<? extends Dialog> codec();

    public record Notice(@NotNull DialogMetadata metadata, @NotNull DialogActionButton action) implements Dialog
    {
        public static final DialogActionButton DEFAULT_ACTION = new DialogActionButton(Component.translatable("gui.ok"), null, 150, null);
        @NotNull
        public static final StructCodec<Notice> CODEC = StructCodec.struct("$$inline$$", DialogMetadata.CODEC, Notice::metadata, "action", DialogActionButton.CODEC.optional(DEFAULT_ACTION), Notice::action, Notice::new);

        @Override
        @NotNull
        public StructCodec<? extends Dialog> codec() {
            return CODEC;
        }
    }

    public record ServerLinks(@NotNull DialogMetadata metadata, @Nullable DialogActionButton exitAction, int columns, int buttonWidth) implements Dialog
    {
        @NotNull
        public static final StructCodec<ServerLinks> CODEC = StructCodec.struct("$$inline$$", DialogMetadata.CODEC, ServerLinks::metadata, "exit_action", DialogActionButton.CODEC.optional(), ServerLinks::exitAction, "columns", Codec.INT.optional(2), ServerLinks::columns, "button_width", Codec.INT.optional(150), ServerLinks::buttonWidth, ServerLinks::new);

        @Override
        @NotNull
        public StructCodec<? extends Dialog> codec() {
            return CODEC;
        }
    }

    public record DialogList(@NotNull DialogMetadata metadata, @NotNull HolderSet<Dialog> dialogs, @Nullable DialogActionButton exitAction, int columns, int buttonWidth) implements Dialog
    {
        @NotNull
        public static final StructCodec<DialogList> CODEC = StructCodec.struct("$$inline$$", DialogMetadata.CODEC, DialogList::metadata, "dialogs", HolderSet.codec(Registries::dialog, REGISTRY_CODEC), DialogList::dialogs, "exit_action", DialogActionButton.CODEC.optional(), DialogList::exitAction, "columns", Codec.INT.optional(2), DialogList::columns, "button_width", Codec.INT.optional(150), DialogList::buttonWidth, DialogList::new);

        @Override
        @NotNull
        public StructCodec<? extends Dialog> codec() {
            return CODEC;
        }
    }

    public record MultiAction(@NotNull DialogMetadata metadata, @NotNull List<DialogActionButton> actions, @Nullable DialogActionButton exitAction, int columns) implements Dialog
    {
        @NotNull
        public static final StructCodec<MultiAction> CODEC = StructCodec.struct("$$inline$$", DialogMetadata.CODEC, MultiAction::metadata, "actions", DialogActionButton.CODEC.list(), MultiAction::actions, "exit_action", DialogActionButton.CODEC.optional(), MultiAction::exitAction, "columns", Codec.INT.optional(2), MultiAction::columns, MultiAction::new);

        @Override
        @NotNull
        public StructCodec<? extends Dialog> codec() {
            return CODEC;
        }
    }

    public record Confirmation(@NotNull DialogMetadata metadata, @NotNull DialogActionButton yesButton, @NotNull DialogActionButton noButton) implements Dialog
    {
        @NotNull
        public static final StructCodec<Confirmation> CODEC = StructCodec.struct("$$inline$$", DialogMetadata.CODEC, Confirmation::metadata, "yes", DialogActionButton.CODEC, Confirmation::yesButton, "no", DialogActionButton.CODEC, Confirmation::noButton, Confirmation::new);

        @Override
        @NotNull
        public StructCodec<? extends Dialog> codec() {
            return CODEC;
        }
    }
}

