/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.ai;

import java.util.Collection;
import java.util.List;
import net.minestom.server.entity.ai.EntityAIGroup;
import net.minestom.server.entity.ai.GoalSelector;
import net.minestom.server.entity.ai.TargetSelector;

public interface EntityAI {
    public Collection<EntityAIGroup> getAIGroups();

    default public void addAIGroup(EntityAIGroup group) {
        this.getAIGroups().add(group);
    }

    default public void addAIGroup(List<GoalSelector> goalSelectors, List<TargetSelector> targetSelectors) {
        EntityAIGroup group = new EntityAIGroup();
        group.getGoalSelectors().addAll(goalSelectors);
        group.getTargetSelectors().addAll(targetSelectors);
        this.addAIGroup(group);
    }

    default public void aiTick(long time) {
        this.getAIGroups().forEach(group -> group.tick(time));
    }
}

