/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.animal;

import net.minestom.server.codec.Codec;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponents;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataDef;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.animal.AnimalMeta;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RabbitMeta
extends AnimalMeta {
    public RabbitMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    @Deprecated
    public void setVariant(@NotNull Variant variant) {
        int id = variant == Variant.KILLER_BUNNY ? 99 : variant.ordinal();
        this.metadata.set(MetadataDef.Rabbit.TYPE, id);
    }

    @Deprecated
    @NotNull
    public Variant getVariant() {
        int id = this.metadata.get(MetadataDef.Rabbit.TYPE);
        if (id == 99) {
            return Variant.KILLER_BUNNY;
        }
        return Variant.VALUES[id];
    }

    @Override
    @Nullable
    protected <T> T get(@NotNull DataComponent<T> component) {
        if (component == DataComponents.RABBIT_VARIANT) {
            return (T)((Object)this.getVariant());
        }
        return super.get(component);
    }

    @Override
    protected <T> void set(@NotNull DataComponent<T> component, @NotNull T value) {
        if (component == DataComponents.RABBIT_VARIANT) {
            this.setVariant((Variant)((Object)value));
        } else {
            super.set(component, value);
        }
    }

    public static enum Variant {
        BROWN,
        WHITE,
        BLACK,
        BLACK_AND_WHITE,
        GOLD,
        SALT_AND_PEPPER,
        KILLER_BUNNY;

        public static final NetworkBuffer.Type<Variant> NETWORK_TYPE;
        public static final Codec<Variant> CODEC;
        private static final Variant[] VALUES;

        static {
            NETWORK_TYPE = NetworkBuffer.Enum(Variant.class);
            CODEC = Codec.Enum(Variant.class);
            VALUES = Variant.values();
        }
    }
}

