/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.generator;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minestom.server.coordinate.CoordConversion;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.generator.GenerationUnit;
import net.minestom.server.instance.generator.UnitModifier;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.biome.Biome;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class GeneratorImpl {
    static GenerationUnit section(DynamicRegistry<Biome> biomeRegistry, GenSection section, int sectionX, int sectionY, int sectionZ, boolean fork) {
        Vec start = Vec.SECTION.mul(sectionX, sectionY, sectionZ);
        Vec end = start.add(Vec.SECTION);
        SectionModifierImpl modifier = new SectionModifierImpl(biomeRegistry, Vec.SECTION, start, end, section, fork);
        return GeneratorImpl.unit(biomeRegistry, modifier, start, end, null);
    }

    public static GenerationUnit section(DynamicRegistry<Biome> biomeRegistry, GenSection section, int sectionX, int sectionY, int sectionZ) {
        return GeneratorImpl.section(biomeRegistry, section, sectionX, sectionY, sectionZ, false);
    }

    public static UnitImpl chunk(DynamicRegistry<Biome> biomeRegistry, GenSection[] chunkSections, int chunkX, int minSection, int chunkZ) {
        Vec start = Vec.SECTION.mul(chunkX, minSection, chunkZ);
        return GeneratorImpl.area(biomeRegistry, start, 1, chunkSections.length, 1, chunkSections);
    }

    public static UnitImpl area(DynamicRegistry<Biome> biomeRegistry, Point start, int width, int height, int depth, GenSection[] areaSections) {
        if (width == 0 || height == 0 || depth == 0) {
            throw new IllegalArgumentException("Width, height and depth must be greater than 0, got " + width + ", " + height + ", " + depth);
        }
        if (areaSections.length != width * height * depth) {
            throw new IllegalArgumentException("Invalid section count, expected " + width * height * depth + " but got " + areaSections.length);
        }
        ArrayList<GenerationUnit> sections = new ArrayList();
        for (int i = 0; i < areaSections.length; ++i) {
            GenSection section = areaSections[i];
            Point point = GeneratorImpl.to3D(i, width, height, depth);
            int sectionX = (int)point.x() + start.chunkX();
            int sectionY = (int)point.y() + start.section();
            int sectionZ = (int)point.z() + start.chunkZ();
            sections.add(GeneratorImpl.section(biomeRegistry, section, sectionX, sectionY, sectionZ));
        }
        sections = List.copyOf(sections);
        Vec size = Vec.SECTION.mul(width, height, depth);
        Point end = start.add(size);
        AreaModifierImpl modifier = new AreaModifierImpl(size, start, end, width, height, depth, sections);
        return GeneratorImpl.unit(biomeRegistry, modifier, start, end, sections);
    }

    public static UnitImpl unit(DynamicRegistry<Biome> biomeRegistry, UnitModifier modifier, Point start, Point end, List<GenerationUnit> divided) {
        if (start.x() > end.x() || start.y() > end.y() || start.z() > end.z()) {
            throw new IllegalArgumentException("absoluteStart must be before absoluteEnd");
        }
        if (start.x() % 16.0 != 0.0 || start.y() % 16.0 != 0.0 || start.z() % 16.0 != 0.0) {
            throw new IllegalArgumentException("absoluteStart must be a multiple of 16");
        }
        if (end.x() % 16.0 != 0.0 || end.y() % 16.0 != 0.0 || end.z() % 16.0 != 0.0) {
            throw new IllegalArgumentException("absoluteEnd must be a multiple of 16");
        }
        Point size = end.sub(start);
        return new UnitImpl(biomeRegistry, modifier, size, start, end, divided, new CopyOnWriteArrayList<UnitImpl>());
    }

    private static GenerationUnit findAbsolute(List<GenerationUnit> units, Point start, int width, int height, int depth, int x, int y, int z) {
        int sectionX = CoordConversion.globalToChunk((double)x - start.x());
        int sectionY = CoordConversion.globalToChunk((double)y - start.y());
        int sectionZ = CoordConversion.globalToChunk((double)z - start.z());
        int index = GeneratorImpl.findIndex(width, height, depth, sectionX, sectionY, sectionZ);
        return units.get(index);
    }

    private static int findIndex(int width, int height, int depth, int x, int y, int z) {
        assert (width > 0 && height > 0 && depth > 0);
        return z * width * height + y * width + x;
    }

    private static Point to3D(int idx, int width, int height, int depth) {
        int z = idx / (width * height);
        int y = (idx -= z * width * height) / width;
        int x = idx % width;
        return new Vec(x, y, z);
    }

    public record SectionModifierImpl(DynamicRegistry<Biome> biomeRegistry, Point size, Point start, Point end, GenSection genSection, boolean fork) implements GenericModifier
    {
        @Override
        public void setBiome(int x, int y, int z, @NotNull RegistryKey<Biome> biome) {
            if (this.fork) {
                throw new IllegalStateException("Cannot modify biomes of a fork");
            }
            int id = this.biomeRegistry.getId(biome);
            Check.argCondition(id == -1, "Biome has not been registered: {0}", biome);
            this.genSection.biomes.set(CoordConversion.globalToSectionRelative(x) / 4, CoordConversion.globalToSectionRelative(y) / 4, CoordConversion.globalToSectionRelative(z) / 4, id);
        }

        @Override
        public void setBlock(int x, int y, int z, @NotNull Block block) {
            int localX = CoordConversion.globalToSectionRelative(x);
            int localY = CoordConversion.globalToSectionRelative(y);
            int localZ = CoordConversion.globalToSectionRelative(z);
            this.handleCache(localX, localY, localZ, block);
            this.genSection.blocks.set(localX, localY, localZ, this.retrieveBlockId(block));
        }

        @Override
        public void setRelative(int x, int y, int z, @NotNull Block block) {
            this.handleCache(x, y, z, block);
            this.genSection.blocks.set(x, y, z, this.retrieveBlockId(block));
        }

        @Override
        public void setAllRelative(@NotNull UnitModifier.Supplier supplier) {
            this.genSection.blocks.setAll((int x, int y, int z) -> {
                Block block = supplier.get(x, y, z);
                this.handleCache(x, y, z, block);
                return this.retrieveBlockId(block);
            });
        }

        @Override
        public void fill(@NotNull Block block) {
            if (this.requireCache(block)) {
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            this.genSection.specials.put(CoordConversion.chunkBlockIndex(x, y, z), block);
                        }
                    }
                }
            }
            this.genSection.blocks.fill(this.retrieveBlockId(block));
        }

        @Override
        public void fillBiome(@NotNull RegistryKey<Biome> biome) {
            if (this.fork) {
                throw new IllegalStateException("Cannot modify biomes of a fork");
            }
            int id = this.biomeRegistry.getId(biome);
            Check.argCondition(id == -1, "Biome has not been registered: {0}", biome);
            this.genSection.biomes.fill(id);
        }

        private int retrieveBlockId(Block block) {
            int stateId = block.stateId();
            return this.fork ? stateId + 1 : stateId;
        }

        private void handleCache(int x, int y, int z, Block block) {
            if (this.requireCache(block)) {
                this.genSection.specials.put(CoordConversion.chunkBlockIndex(x, y, z), block);
            } else if (!this.genSection.specials.isEmpty()) {
                this.genSection.specials.remove(CoordConversion.chunkBlockIndex(x, y, z));
            }
        }

        private boolean requireCache(Block block) {
            return block.hasNbt() || block.handler() != null || block.registry().isBlockEntity();
        }
    }

    public record GenSection(Palette blocks, Palette biomes, Int2ObjectMap<Block> specials) {
        public GenSection(Palette blocks, Palette biomes) {
            this(blocks, biomes, new Int2ObjectOpenHashMap<Block>(0));
        }

        public GenSection() {
            this(Palette.blocks(), Palette.biomes());
        }
    }

    public record UnitImpl(DynamicRegistry<Biome> biomeRegistry, UnitModifier modifier, Point size, Point absoluteStart, Point absoluteEnd, List<GenerationUnit> divided, List<UnitImpl> forks) implements GenerationUnit
    {
        @Override
        @NotNull
        public GenerationUnit fork(@NotNull Point start, @NotNull Point end) {
            int minSectionX = CoordConversion.floorSection(start.blockX()) / 16;
            int minSectionY = CoordConversion.floorSection(start.blockY()) / 16;
            int minSectionZ = CoordConversion.floorSection(start.blockZ()) / 16;
            int maxSectionX = CoordConversion.ceilSection(end.blockX()) / 16;
            int maxSectionY = CoordConversion.ceilSection(end.blockY()) / 16;
            int maxSectionZ = CoordConversion.ceilSection(end.blockZ()) / 16;
            int width = maxSectionX - minSectionX;
            int height = maxSectionY - minSectionY;
            int depth = maxSectionZ - minSectionZ;
            GenerationUnit[] units = new GenerationUnit[width * height * depth];
            int index = 0;
            for (int sectionZ = minSectionZ; sectionZ < maxSectionZ; ++sectionZ) {
                for (int sectionY = minSectionY; sectionY < maxSectionY; ++sectionY) {
                    for (int sectionX = minSectionX; sectionX < maxSectionX; ++sectionX) {
                        GenerationUnit unit = GeneratorImpl.section(this.biomeRegistry, new GenSection(), sectionX, sectionY, sectionZ, true);
                        units[index++] = unit;
                    }
                }
            }
            List<GenerationUnit> sections = List.of(units);
            Vec startSection = Vec.SECTION.mul(minSectionX, minSectionY, minSectionZ);
            return this.registerFork(startSection, sections, width, height, depth);
        }

        @Override
        public void fork(@NotNull @NotNull Consumer<@NotNull Block.Setter> consumer) {
            DynamicFork dynamicFork = new DynamicFork(this.biomeRegistry);
            consumer.accept(dynamicFork);
            Vec startSection = dynamicFork.minSection;
            if (startSection == null) {
                return;
            }
            int width = dynamicFork.width;
            int height = dynamicFork.height;
            int depth = dynamicFork.depth;
            List<GenerationUnit> sections = dynamicFork.sections;
            this.registerFork(startSection, sections, width, height, depth);
        }

        @Override
        @NotNull
        public List<GenerationUnit> subdivide() {
            return Objects.requireNonNullElseGet(this.divided, () -> GenerationUnit.super.subdivide());
        }

        private GenerationUnit registerFork(Point start, List<GenerationUnit> sections, int width, int height, int depth) {
            Point end = start.add(width * 16, height * 16, depth * 16);
            Point size = end.sub(start);
            AreaModifierImpl modifier = new AreaModifierImpl(size, start, end, width, height, depth, sections);
            UnitImpl fork = new UnitImpl(this.biomeRegistry, modifier, size, start, end, sections, this.forks);
            this.forks.add(fork);
            return fork;
        }
    }

    public record AreaModifierImpl(Point size, Point start, Point end, int width, int height, int depth, List<GenerationUnit> sections) implements GenericModifier
    {
        @Override
        public void setBlock(int x, int y, int z, @NotNull Block block) {
            this.checkBorder(x, y, z);
            GenerationUnit section = this.findAbsoluteSection(x, y, z);
            y = (int)((double)y - this.start.y());
            section.modifier().setBlock(x, y, z, block);
        }

        @Override
        public void setBiome(int x, int y, int z, @NotNull RegistryKey<Biome> biome) {
            this.checkBorder(x, y, z);
            GenerationUnit section = this.findAbsoluteSection(x, y, z);
            y = (int)((double)y - this.start.y());
            section.modifier().setBiome(x, y, z, biome);
        }

        @Override
        public void setRelative(int x, int y, int z, @NotNull Block block) {
            if (x < 0 || (double)x >= this.size.x() || y < 0 || (double)y >= this.size.y() || z < 0 || (double)z >= this.size.z()) {
                throw new IllegalArgumentException("x, y and z must be in the chunk: " + x + ", " + y + ", " + z);
            }
            GenerationUnit section = this.findRelativeSection(x, y, z);
            x = CoordConversion.globalToSectionRelative(x);
            y = CoordConversion.globalToSectionRelative(y);
            z = CoordConversion.globalToSectionRelative(z);
            section.modifier().setBlock(x, y, z, block);
        }

        @Override
        public void setAll(@NotNull UnitModifier.Supplier supplier) {
            for (GenerationUnit section : this.sections) {
                Point start = section.absoluteStart();
                int startX = start.blockX();
                int startY = start.blockY();
                int startZ = start.blockZ();
                section.modifier().setAllRelative((x, y, z) -> supplier.get(x + startX, y + startY, z + startZ));
            }
        }

        @Override
        public void setAllRelative(@NotNull UnitModifier.Supplier supplier) {
            Point start = this.start;
            for (GenerationUnit section : this.sections) {
                Point sectionStart = section.absoluteStart();
                int offsetX = sectionStart.blockX() - start.blockX();
                int offsetY = sectionStart.blockY() - start.blockY();
                int offsetZ = sectionStart.blockZ() - start.blockZ();
                section.modifier().setAllRelative((x, y, z) -> supplier.get(x + offsetX, y + offsetY, z + offsetZ));
            }
        }

        @Override
        public void fill(@NotNull Block block) {
            for (GenerationUnit section : this.sections) {
                section.modifier().fill(block);
            }
        }

        @Override
        public void fillBiome(@NotNull RegistryKey<Biome> biome) {
            for (GenerationUnit section : this.sections) {
                section.modifier().fillBiome(biome);
            }
        }

        @Override
        public void fillHeight(int minHeight, int maxHeight, @NotNull Block block) {
            boolean endOffset;
            Point start = this.start;
            int width = this.width;
            int depth = this.depth;
            int startX = start.blockX();
            int startZ = start.blockZ();
            int minMultiple = CoordConversion.floorSection(minHeight);
            int maxMultiple = CoordConversion.ceilSection(maxHeight);
            boolean startOffset = minMultiple != minHeight;
            boolean bl = endOffset = maxMultiple != maxHeight;
            if (startOffset || endOffset) {
                int firstFill = Math.min(minMultiple + 16, maxHeight);
                int lastFill = startOffset ? Math.max(firstFill, CoordConversion.floorSection(maxHeight)) : CoordConversion.floorSection(maxHeight);
                for (int x = 0; x < width; ++x) {
                    for (int z = 0; z < depth; ++z) {
                        GenerationUnit section;
                        int sectionX = startX + x * 16;
                        int sectionZ = startZ + z * 16;
                        if (startOffset) {
                            section = this.findAbsoluteSection(sectionX, minMultiple, sectionZ);
                            section.modifier().fillHeight(minHeight, firstFill, block);
                        }
                        if (!endOffset) continue;
                        section = this.findAbsoluteSection(sectionX, maxHeight, sectionZ);
                        section.modifier().fillHeight(lastFill, maxHeight, block);
                    }
                }
            }
            int startSection = minMultiple / 16 + (startOffset ? 1 : 0);
            int endSection = maxMultiple / 16 + (endOffset ? -1 : 0);
            for (int i = startSection; i < endSection; ++i) {
                for (int x = 0; x < width; ++x) {
                    for (int z = 0; z < depth; ++z) {
                        GenerationUnit section = this.findAbsoluteSection(startX + x * 16, i * 16, startZ + z * 16);
                        section.modifier().fill(block);
                    }
                }
            }
        }

        private GenerationUnit findAbsoluteSection(int x, int y, int z) {
            return GeneratorImpl.findAbsolute(this.sections, this.start, this.width, this.height, this.depth, x, y, z);
        }

        private GenerationUnit findRelativeSection(int x, int y, int z) {
            return GeneratorImpl.findAbsolute(this.sections, Vec.ZERO, this.width, this.height, this.depth, x, y, z);
        }

        private void checkBorder(int x, int y, int z) {
            if ((double)x < this.start.x() || (double)x >= this.end.x() || (double)y < this.start.y() || (double)y >= this.end.y() || (double)z < this.start.z() || (double)z >= this.end.z()) {
                String format = String.format("Invalid coordinates: %d, %d, %d for area %s %s", x, y, z, this.start, this.end);
                throw new IllegalArgumentException(format);
            }
        }
    }

    static sealed interface GenericModifier
    extends UnitModifier
    permits AreaModifierImpl, SectionModifierImpl {
        public Point size();

        public Point start();

        public Point end();

        @Override
        default public void setAll(@NotNull UnitModifier.Supplier supplier) {
            Point start = this.start();
            Point end = this.end();
            int endX = end.blockX();
            int endY = end.blockY();
            int endZ = end.blockZ();
            for (int x = start.blockX(); x < endX; ++x) {
                for (int y = start.blockY(); y < endY; ++y) {
                    for (int z = start.blockZ(); z < endZ; ++z) {
                        this.setBlock(x, y, z, supplier.get(x, y, z));
                    }
                }
            }
        }

        @Override
        default public void setAllRelative(@NotNull UnitModifier.Supplier supplier) {
            Point size = this.size();
            int endX = size.blockX();
            int endY = size.blockY();
            int endZ = size.blockZ();
            for (int x = 0; x < endX; ++x) {
                for (int y = 0; y < endY; ++y) {
                    for (int z = 0; z < endZ; ++z) {
                        this.setRelative(x, y, z, supplier.get(x, y, z));
                    }
                }
            }
        }

        @Override
        default public void fill(@NotNull Block block) {
            this.fill(this.start(), this.end(), block);
        }

        @Override
        default public void fill(@NotNull Point start, @NotNull Point end, @NotNull Block block) {
            int endX = end.blockX();
            int endY = end.blockY();
            int endZ = end.blockZ();
            for (int x = start.blockX(); x < endX; ++x) {
                for (int y = start.blockY(); y < endY; ++y) {
                    for (int z = start.blockZ(); z < endZ; ++z) {
                        this.setBlock(x, y, z, block);
                    }
                }
            }
        }

        @Override
        default public void fillHeight(int minHeight, int maxHeight, @NotNull Block block) {
            Point start = this.start();
            Point end = this.end();
            int startY = start.blockY();
            int endY = end.blockY();
            if (startY >= minHeight && endY <= maxHeight) {
                this.fill(start, end, block);
            } else {
                this.fill(start.withY(Math.max(minHeight, startY)), end.withY(Math.min(maxHeight, endY)), block);
            }
        }
    }

    static final class DynamicFork
    implements Block.Setter {
        final DynamicRegistry<Biome> biomeRegistry;
        Vec minSection;
        int width;
        int height;
        int depth;
        List<GenerationUnit> sections;

        DynamicFork(DynamicRegistry<Biome> biomeRegistry) {
            this.biomeRegistry = biomeRegistry;
        }

        @Override
        public void setBlock(int x, int y, int z, @NotNull Block block) {
            this.resize(x, y, z);
            GenerationUnit section = GeneratorImpl.findAbsolute(this.sections, this.minSection, this.width, this.height, this.depth, x, y, z);
            assert (section.absoluteStart().chunkX() == CoordConversion.globalToChunk(x) && section.absoluteStart().section() == CoordConversion.globalToChunk(y) && section.absoluteStart().chunkZ() == CoordConversion.globalToChunk(z)) : "Invalid section " + String.valueOf(section.absoluteStart()) + " for " + x + ", " + y + ", " + z;
            section.modifier().setBlock(x, y, z, block);
        }

        private void resize(int x, int y, int z) {
            int sectionX = CoordConversion.globalToChunk(x);
            int sectionY = CoordConversion.globalToChunk(y);
            int sectionZ = CoordConversion.globalToChunk(z);
            if (this.sections == null) {
                this.minSection = Vec.SECTION.mul(sectionX, sectionY, sectionZ);
                this.width = 1;
                this.height = 1;
                this.depth = 1;
                this.sections = List.of(GeneratorImpl.section(this.biomeRegistry, new GenSection(), sectionX, sectionY, sectionZ, true));
            } else if ((double)x < this.minSection.x() || (double)y < this.minSection.y() || (double)z < this.minSection.z() || (double)x >= this.minSection.x() + (double)(this.width * 16) || (double)y >= this.minSection.y() + (double)(this.height * 16) || (double)z >= this.minSection.z() + (double)(this.depth * 16)) {
                Vec newMin = new Vec(Math.min(this.minSection.x(), (double)(sectionX * 16)), Math.min(this.minSection.y(), (double)(sectionY * 16)), Math.min(this.minSection.z(), (double)(sectionZ * 16)));
                Vec newMax = new Vec(Math.max(this.minSection.x() + (double)(this.width * 16), (double)(sectionX * 16 + 16)), Math.max(this.minSection.y() + (double)(this.height * 16), (double)(sectionY * 16 + 16)), Math.max(this.minSection.z() + (double)(this.depth * 16), (double)(sectionZ * 16 + 16)));
                int newWidth = CoordConversion.globalToChunk(newMax.x() - newMin.x());
                int newHeight = CoordConversion.globalToChunk(newMax.y() - newMin.y());
                int newDepth = CoordConversion.globalToChunk(newMax.z() - newMin.z());
                GenerationUnit[] newSections = new GenerationUnit[newWidth * newHeight * newDepth];
                for (GenerationUnit s : this.sections) {
                    Point start = s.absoluteStart();
                    int newX = CoordConversion.globalToChunk(start.x() - newMin.x());
                    int newY = CoordConversion.globalToChunk(start.y() - newMin.y());
                    int newZ = CoordConversion.globalToChunk(start.z() - newMin.z());
                    int index = GeneratorImpl.findIndex(newWidth, newHeight, newDepth, newX, newY, newZ);
                    newSections[index] = s;
                }
                int startX = newMin.chunkX();
                int startY = newMin.section();
                int startZ = newMin.chunkZ();
                for (int i = 0; i < newSections.length; ++i) {
                    GenerationUnit unit;
                    if (newSections[i] != null) continue;
                    Point coordinates = GeneratorImpl.to3D(i, newWidth, newHeight, newDepth);
                    int newX = coordinates.blockX() + startX;
                    int newY = coordinates.blockY() + startY;
                    int newZ = coordinates.blockZ() + startZ;
                    newSections[i] = unit = GeneratorImpl.section(this.biomeRegistry, new GenSection(), newX, newY, newZ, true);
                }
                this.sections = List.of(newSections);
                this.minSection = newMin;
                this.width = newWidth;
                this.height = newHeight;
                this.depth = newDepth;
            }
        }
    }
}

