/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.palette;

import net.minestom.server.instance.palette.Palette;
import net.minestom.server.instance.palette.SpecializedPalette;
import org.jetbrains.annotations.NotNull;

record PaletteSingle(byte dim, int value) implements SpecializedPalette.Immutable
{
    @Override
    public int get(int x, int y, int z) {
        return this.value;
    }

    @Override
    public void getAll(@NotNull Palette.EntryConsumer consumer) {
        byte dimension = this.dim;
        int value = this.value;
        for (byte y = 0; y < dimension; y = (byte)(y + 1)) {
            for (byte z = 0; z < dimension; z = (byte)(z + 1)) {
                for (byte x = 0; x < dimension; x = (byte)(x + 1)) {
                    consumer.accept(x, y, z, value);
                }
            }
        }
    }

    @Override
    public void getAllPresent(@NotNull Palette.EntryConsumer consumer) {
        if (this.value != 0) {
            this.getAll(consumer);
        }
    }

    @Override
    public int count() {
        return this.value != 0 ? this.maxSize() : 0;
    }

    @Override
    public int dimension() {
        return this.dim;
    }

    @Override
    @NotNull
    public SpecializedPalette clone() {
        return this;
    }
}

