/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.armor;

import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.item.Material;
import net.minestom.server.item.armor.TrimMaterialImpl;
import net.minestom.server.item.armor.TrimMaterials;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Holder;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public sealed interface TrimMaterial
extends Holder.Direct<TrimMaterial>,
TrimMaterials
permits TrimMaterialImpl {
    @NotNull
    public static final NetworkBuffer.Type<TrimMaterial> REGISTRY_NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.STRING, TrimMaterial::assetName, NetworkBuffer.STRING.mapValue(NetworkBuffer.STRING), TrimMaterial::overrideArmorMaterials, NetworkBuffer.COMPONENT, TrimMaterial::description, TrimMaterial::create);
    @NotNull
    public static final Codec<TrimMaterial> REGISTRY_CODEC = StructCodec.struct("asset_name", Codec.STRING, TrimMaterial::assetName, "override_armor_materials", Codec.STRING.mapValue(Codec.STRING).optional(Map.of()), TrimMaterial::overrideArmorMaterials, "description", Codec.COMPONENT, TrimMaterial::description, TrimMaterial::create);
    @NotNull
    public static final NetworkBuffer.Type<Holder<TrimMaterial>> NETWORK_TYPE = Holder.networkType(Registries::trimMaterial, REGISTRY_NETWORK_TYPE);
    @NotNull
    public static final Codec<Holder<TrimMaterial>> CODEC = Holder.codec(Registries::trimMaterial, REGISTRY_CODEC);

    @NotNull
    public static TrimMaterial create(@NotNull String assetName, @NotNull Map<String, String> overrideArmorMaterials, @NotNull Component description) {
        return new TrimMaterialImpl(assetName, overrideArmorMaterials, description);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<TrimMaterial> createDefaultRegistry() {
        return DynamicRegistry.create(Key.key("minecraft:trim_material"), REGISTRY_CODEC, RegistryData.Resource.TRIM_MATERIALS);
    }

    @NotNull
    public String assetName();

    @NotNull
    public Map<String, String> overrideArmorMaterials();

    @NotNull
    public Component description();

    public static final class Builder {
        private String assetName;
        private Material ingredient;
        private final Map<String, String> overrideArmorMaterials = new HashMap<String, String>();
        private Component description;

        private Builder() {
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder assetName(@NotNull String assetName) {
            this.assetName = assetName;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder overrideArmorMaterials(@NotNull Map<String, String> overrideArmorMaterials) {
            this.overrideArmorMaterials.putAll(overrideArmorMaterials);
            return this;
        }

        @Contract(value="_, _ -> this", pure=true)
        @NotNull
        public Builder overrideArmorMaterial(@NotNull String slot, @NotNull String material) {
            this.overrideArmorMaterials.put(slot, material);
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder description(@NotNull Component description) {
            this.description = description;
            return this;
        }

        @Contract(pure=true)
        @NotNull
        public TrimMaterial build() {
            return new TrimMaterialImpl(this.assetName, this.overrideArmorMaterials, this.description);
        }
    }
}

