/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.enchant;

import java.util.List;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.gamedata.DataPack;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registries;
import net.minestom.server.utils.MathUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LevelBasedValue {
    @NotNull
    public static final StructCodec<LevelBasedValue> TAGGED_CODEC = Codec.RegistryTaggedUnion(Registries::enchantmentLevelBasedValues, LevelBasedValue::codec, "type");
    @NotNull
    public static final Codec<LevelBasedValue> CODEC = new Codec<LevelBasedValue>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable LevelBasedValue value) {
            if (!(value instanceof Constant)) return TAGGED_CODEC.encode(coder, value);
            Constant constant = (Constant)value;
            try {
                float f;
                float constantValue = f = constant.value();
                return new Result.Ok<D>(coder.createFloat(constantValue));
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<LevelBasedValue> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            Result<Float> numberResult = coder.getFloat(value);
            if (!(numberResult instanceof Result.Ok)) return TAGGED_CODEC.decode(coder, value);
            Result.Ok ok = (Result.Ok)numberResult;
            try {
                Float f;
                Float number = f = (Float)ok.value();
                return new Result.Ok<LevelBasedValue>(new Constant(number.floatValue()));
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
    };

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<StructCodec<? extends LevelBasedValue>> createDefaultRegistry() {
        DynamicRegistry<StructCodec<? extends LevelBasedValue>> registry = DynamicRegistry.create(Key.key("minestom:enchantment_value_effect"));
        registry.register("linear", Linear.CODEC, DataPack.MINECRAFT_CORE);
        registry.register("clamped", Clamped.CODEC, DataPack.MINECRAFT_CORE);
        registry.register("fraction", Fraction.CODEC, DataPack.MINECRAFT_CORE);
        registry.register("levels_squared", LevelsSquared.CODEC, DataPack.MINECRAFT_CORE);
        registry.register("lookup", Lookup.CODEC, DataPack.MINECRAFT_CORE);
        return registry;
    }

    public float calc(int var1);

    @NotNull
    public StructCodec<? extends LevelBasedValue> codec();

    public record Linear(float base, float perLevelAboveFirst) implements LevelBasedValue
    {
        public static final StructCodec<Linear> CODEC = StructCodec.struct("base", Codec.FLOAT, Linear::base, "per_level_above_first", Codec.FLOAT, Linear::perLevelAboveFirst, Linear::new);

        @Override
        public float calc(int level) {
            return this.base + this.perLevelAboveFirst * (float)(level - 1);
        }

        @NotNull
        public StructCodec<Linear> codec() {
            return CODEC;
        }
    }

    public record Clamped(@NotNull LevelBasedValue value, float min, float max) implements LevelBasedValue
    {
        public static final StructCodec<Clamped> CODEC = StructCodec.struct("value", CODEC, Clamped::value, "min", Codec.FLOAT, Clamped::min, "max", Codec.FLOAT, Clamped::max, Clamped::new);

        @Override
        public float calc(int level) {
            return MathUtils.clamp(this.value.calc(level), this.min, this.max);
        }

        @NotNull
        public StructCodec<Clamped> codec() {
            return CODEC;
        }
    }

    public record Fraction(@NotNull LevelBasedValue numerator, @NotNull LevelBasedValue denominator) implements LevelBasedValue
    {
        public static final StructCodec<Fraction> CODEC = StructCodec.struct("numerator", CODEC, Fraction::numerator, "denominator", CODEC, Fraction::denominator, Fraction::new);

        @Override
        public float calc(int level) {
            float denominator = this.denominator.calc(level);
            return denominator == 0.0f ? 0.0f : this.numerator.calc(level) / denominator;
        }

        @NotNull
        public StructCodec<Fraction> codec() {
            return CODEC;
        }
    }

    public record LevelsSquared(float added) implements LevelBasedValue
    {
        public static final StructCodec<LevelsSquared> CODEC = StructCodec.struct("added", Codec.FLOAT, LevelsSquared::added, LevelsSquared::new);

        @Override
        public float calc(int level) {
            return (float)(level * level) + this.added;
        }

        @NotNull
        public StructCodec<LevelsSquared> codec() {
            return CODEC;
        }
    }

    public record Lookup(@NotNull List<Float> values, @NotNull LevelBasedValue fallback) implements LevelBasedValue
    {
        public static final StructCodec<Lookup> CODEC = StructCodec.struct("values", Codec.FLOAT.list(), Lookup::values, "fallback", CODEC, Lookup::fallback, Lookup::new);

        @Override
        public float calc(int level) {
            if (level < 0 || level > this.values.size()) {
                return this.fallback.calc(level);
            }
            return this.values.get(level - 1).floatValue();
        }

        @NotNull
        public StructCodec<Lookup> codec() {
            return CODEC;
        }
    }

    public record Constant(float value) implements LevelBasedValue
    {
        @Override
        public float calc(int level) {
            return this.value;
        }

        @NotNull
        public StructCodec<Constant> codec() {
            throw new UnsupportedOperationException("Constant values are serialized as a special case, see LevelBasedValue.CODEC");
        }
    }
}

