/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minestom.server.entity.Player;
import net.minestom.server.item.Material;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.play.DeclareRecipesPacket;
import net.minestom.server.network.packet.server.play.RecipeBookAddPacket;
import net.minestom.server.recipe.Ingredient;
import net.minestom.server.recipe.Recipe;
import net.minestom.server.recipe.RecipeBookCategory;
import net.minestom.server.recipe.RecipeProperty;
import net.minestom.server.recipe.display.RecipeDisplay;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RecipeManager {
    private static final AtomicInteger NEXT_DISPLAY_ID = new AtomicInteger();
    private final CachedPacket declareRecipesPacket = new CachedPacket(this::createDeclareRecipesPacket);
    private final Map<Recipe, RecipeData> recipes = new ConcurrentHashMap<Recipe, RecipeData>();
    private final Int2ObjectMap<Map.Entry<RecipeBookAddPacket.Entry, Predicate<Player>>> recipeBookEntryIdMap = Int2ObjectMaps.synchronize(new Int2ObjectArrayMap());

    public void addRecipe(@NotNull Recipe recipe) {
        this.addRecipe(recipe, player -> true);
    }

    public void addRecipe(@NotNull Recipe recipe, @NotNull Predicate<Player> predicate) {
        RecipeData existingRecipe;
        ArrayList<RecipeBookAddPacket.Entry> recipeBookEntries = new ArrayList<RecipeBookAddPacket.Entry>();
        RecipeBookCategory recipeBookCategory = recipe.recipeBookCategory();
        if (recipeBookCategory != null) {
            for (RecipeDisplay display : recipe.createRecipeDisplays()) {
                int displayId = NEXT_DISPLAY_ID.getAndIncrement();
                recipeBookEntries.add(new RecipeBookAddPacket.Entry(displayId, display, null, recipeBookCategory, recipe.craftingRequirements(), false, false));
            }
        }
        Check.argCondition((existingRecipe = this.recipes.putIfAbsent(recipe, new RecipeData(recipe, recipeBookEntries, predicate))) != null, "Recipe is already registered: " + String.valueOf(recipe));
        for (RecipeBookAddPacket.Entry entry : recipeBookEntries) {
            this.recipeBookEntryIdMap.put(entry.displayId(), Map.entry(entry, predicate));
        }
    }

    public void removeRecipe(@NotNull Recipe recipe) {
        RecipeData removed = this.recipes.remove(recipe);
        if (removed != null) {
            for (RecipeBookAddPacket.Entry entry : removed.displays) {
                this.recipeBookEntryIdMap.remove(entry.displayId());
            }
        }
    }

    @NotNull
    public Set<Recipe> getRecipes() {
        return this.recipes.keySet();
    }

    @Nullable
    public RecipeDisplay getRecipeDisplay(int displayId, @Nullable Player player) {
        Map.Entry recipeBookEntry = (Map.Entry)this.recipeBookEntryIdMap.get(displayId);
        if (recipeBookEntry == null || player != null && !((Predicate)recipeBookEntry.getValue()).test(player)) {
            return null;
        }
        return ((RecipeBookAddPacket.Entry)recipeBookEntry.getKey()).display();
    }

    @NotNull
    public SendablePacket getDeclareRecipesPacket() {
        return this.declareRecipesPacket;
    }

    @NotNull
    public RecipeBookAddPacket createRecipeBookResetPacket(@NotNull Player player) {
        ArrayList<RecipeBookAddPacket.Entry> entries = new ArrayList<RecipeBookAddPacket.Entry>();
        for (Map.Entry<Recipe, RecipeData> recipeEntry : this.recipes.entrySet()) {
            if (!recipeEntry.getValue().predicate.test(player)) continue;
            entries.addAll(recipeEntry.getValue().displays);
        }
        return new RecipeBookAddPacket(entries, true);
    }

    @NotNull
    private DeclareRecipesPacket createDeclareRecipesPacket() {
        HashMap<RecipeProperty, Set> itemProperties = new HashMap<RecipeProperty, Set>();
        for (Recipe recipe : this.recipes.keySet()) {
            for (Map.Entry<RecipeProperty, List<Material>> entry : recipe.itemProperties().entrySet()) {
                itemProperties.computeIfAbsent(entry.getKey(), k -> new HashSet()).addAll((Collection)entry.getValue());
            }
        }
        HashMap<RecipeProperty, List<Material>> itemPropertiesLists = new HashMap<RecipeProperty, List<Material>>();
        for (Map.Entry entry : itemProperties.entrySet()) {
            itemPropertiesLists.put((RecipeProperty)entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        ArrayList<DeclareRecipesPacket.StonecutterRecipe> arrayList = new ArrayList<DeclareRecipesPacket.StonecutterRecipe>();
        for (Map.Entry recipeBookEntry : this.recipeBookEntryIdMap.values()) {
            RecipeDisplay.Stonecutter stonecutterDisplay;
            Ingredient input;
            RecipeDisplay recipeDisplay = ((RecipeBookAddPacket.Entry)recipeBookEntry.getKey()).display();
            if (!(recipeDisplay instanceof RecipeDisplay.Stonecutter) || (input = Ingredient.fromSlotDisplay((stonecutterDisplay = (RecipeDisplay.Stonecutter)recipeDisplay).ingredient())) == null) continue;
            arrayList.add(new DeclareRecipesPacket.StonecutterRecipe(input, stonecutterDisplay.result()));
        }
        return new DeclareRecipesPacket(itemPropertiesLists, arrayList);
    }

    private record RecipeData(@NotNull Recipe recipe, @NotNull List<RecipeBookAddPacket.Entry> displays, @NotNull Predicate<Player> predicate) {
    }
}

