/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.scoreboard;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.minestom.server.network.packet.server.play.TeamsPacket;
import net.minestom.server.scoreboard.Team;
import net.minestom.server.scoreboard.TeamManager;

public class TeamBuilder {
    private final TeamManager teamManager;
    private final Team team;
    private boolean updateTeam;

    public TeamBuilder(String name, TeamManager teamManager) {
        this(teamManager.exists(name) ? teamManager.getTeam(name) : new Team(name), teamManager);
    }

    private TeamBuilder(Team team, TeamManager teamManager) {
        this.team = team;
        this.teamManager = teamManager;
        this.updateTeam = false;
    }

    public TeamBuilder updatePrefix(Component prefix) {
        this.team.updatePrefix(prefix);
        return this;
    }

    public TeamBuilder updateTeamColor(NamedTextColor color) {
        this.team.updateTeamColor(color);
        return this;
    }

    public TeamBuilder updateSuffix(Component suffix) {
        this.team.updateSuffix(suffix);
        return this;
    }

    public TeamBuilder updateTeamDisplayName(Component displayName) {
        this.team.updateTeamDisplayName(displayName);
        return this;
    }

    public TeamBuilder updateCollisionRule(TeamsPacket.CollisionRule rule) {
        this.team.updateCollisionRule(rule);
        return this;
    }

    public TeamBuilder updateNameTagVisibility(TeamsPacket.NameTagVisibility visibility) {
        this.team.updateNameTagVisibility(visibility);
        return this;
    }

    public TeamBuilder updateFriendlyFlags(byte flag) {
        this.team.updateFriendlyFlags(flag);
        return this;
    }

    public TeamBuilder updateAllowFriendlyFire() {
        this.team.updateAllowFriendlyFire(true);
        return this;
    }

    public TeamBuilder updateSeeInvisiblePlayers() {
        this.team.updateSeeInvisiblePlayers(true);
        return this;
    }

    public TeamBuilder prefix(Component prefix) {
        this.team.setPrefix(prefix);
        return this;
    }

    public TeamBuilder suffix(Component suffix) {
        this.team.setSuffix(suffix);
        return this;
    }

    public TeamBuilder teamColor(NamedTextColor color) {
        this.team.setTeamColor(color);
        return this;
    }

    public TeamBuilder teamDisplayName(Component displayName) {
        this.team.setTeamDisplayName(displayName);
        return this;
    }

    public TeamBuilder collisionRule(TeamsPacket.CollisionRule rule) {
        this.team.setCollisionRule(rule);
        return this;
    }

    public TeamBuilder nameTagVisibility(TeamsPacket.NameTagVisibility visibility) {
        this.team.setNameTagVisibility(visibility);
        return this;
    }

    public TeamBuilder friendlyFlags(byte flag) {
        this.team.setFriendlyFlags(flag);
        return this;
    }

    public TeamBuilder allowFriendlyFire() {
        this.team.setAllowFriendlyFire(true);
        return this;
    }

    public TeamBuilder seeInvisiblePlayers() {
        this.team.setSeeInvisiblePlayers(true);
        return this;
    }

    public TeamBuilder updateTeamPacket() {
        this.updateTeam = true;
        return this;
    }

    public Team build() {
        if (!this.teamManager.exists(this.team)) {
            this.teamManager.registerNewTeam(this.team);
        }
        if (this.updateTeam) {
            this.team.sendUpdatePacket();
            this.updateTeam = false;
        }
        return this.team;
    }
}

