/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import net.minestom.server.utils.Direction;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class MathUtils {
    private MathUtils() {
    }

    public static int square(int num) {
        return num * num;
    }

    public static float square(float num) {
        return num * num;
    }

    public static double square(double num) {
        return num * num;
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public static float round(float value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (float)factor);
        return (float)tmp / (float)factor;
    }

    public static Direction getHorizontalDirection(float yawInDegrees) {
        int directionIndex = (int)Math.floor((yawInDegrees + 45.0f) / 90.0f);
        if (directionIndex < 0) {
            directionIndex = -directionIndex % Direction.HORIZONTAL.length;
            directionIndex = Direction.HORIZONTAL.length - directionIndex;
        }
        return Direction.HORIZONTAL[directionIndex %= Direction.HORIZONTAL.length];
    }

    public static boolean isBetween(byte number, byte min, byte max) {
        return number >= min && number <= max;
    }

    public static boolean isBetween(int number, int min, int max) {
        return number >= min && number <= max;
    }

    public static boolean isBetween(double number, double min, double max) {
        return number >= min && number <= max;
    }

    public static boolean isBetween(float number, float min, float max) {
        return number >= min && number <= max;
    }

    public static boolean isBetweenUnordered(double number, double compare1, double compare2) {
        if (compare1 > compare2) {
            return MathUtils.isBetween(number, compare2, compare1);
        }
        return MathUtils.isBetween(number, compare1, compare2);
    }

    public static boolean isBetweenUnordered(float number, float compare1, float compare2) {
        if (compare1 > compare2) {
            return MathUtils.isBetween(number, compare2, compare1);
        }
        return MathUtils.isBetween(number, compare1, compare2);
    }

    public static int clamp(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    public static float clamp(float value, float min, float max) {
        return Math.min(Math.max(value, min), max);
    }

    public static double clamp(double value, double min, double max) {
        return Math.min(Math.max(value, min), max);
    }

    public static double mod(double a, double b) {
        return (a % b + b) % b;
    }

    public static int bitsToRepresent(int n) {
        Check.argCondition(n < 1, "n must be greater than 0");
        return 32 - Integer.numberOfLeadingZeros(n);
    }
}

