/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import java.util.UUID;
import java.util.regex.Pattern;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class UUIDUtils {
    public static final Pattern UNIQUE_ID_PATTERN = Pattern.compile("\\b[0-9a-f]{8}\\b-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-\\b[0-9a-f]{12}\\b");

    public static boolean isUuid(String input) {
        return UNIQUE_ID_PATTERN.matcher(input).matches();
    }

    @NotNull
    public static UUID fromNbt(@NotNull IntArrayBinaryTag tag) {
        return UUIDUtils.intArrayToUuid(tag.value());
    }

    @NotNull
    public static IntArrayBinaryTag toNbt(@NotNull UUID uuid) {
        return IntArrayBinaryTag.intArrayBinaryTag(UUIDUtils.uuidToIntArray(uuid));
    }

    public static int[] uuidToIntArray(UUID uuid) {
        long uuidMost = uuid.getMostSignificantBits();
        long uuidLeast = uuid.getLeastSignificantBits();
        return new int[]{(int)(uuidMost >> 32), (int)uuidMost, (int)(uuidLeast >> 32), (int)uuidLeast};
    }

    public static UUID intArrayToUuid(int[] array) {
        long uuidMost = (long)array[0] << 32 | (long)array[1] & 0xFFFFFFFFL;
        long uuidLeast = (long)array[2] << 32 | (long)array[3] & 0xFFFFFFFFL;
        return new UUID(uuidMost, uuidLeast);
    }
}

