/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.collection;

import java.util.Arrays;
import net.minestom.server.utils.collection.ObjectArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

final class ObjectArrayImpl {
    ObjectArrayImpl() {
    }

    static final class Concurrent<T>
    implements ObjectArray<T> {
        private volatile T[] array;
        private int max;

        Concurrent(int size) {
            this.array = new Object[size];
        }

        @Override
        public @UnknownNullability T get(int index) {
            T[] array = this.array;
            return index < array.length ? (T)array[index] : null;
        }

        @Override
        public synchronized void set(int index, @Nullable T object) {
            T[] array = this.array;
            if (index >= array.length) {
                int newLength = index * 2 + 1;
                this.array = array = Arrays.copyOf(array, newLength);
            }
            array[index] = object;
            this.max = Math.max(this.max, index);
        }

        @Override
        public synchronized void trim() {
            this.array = Arrays.copyOf(this.array, this.max + 1);
        }

        @Override
        public @UnknownNullability T @NotNull [] arrayCopy(@NotNull Class<T> type) {
            return Arrays.copyOf(this.array, this.max + 1, (Class<? extends T[]>)type.arrayType());
        }
    }

    static final class SingleThread<T>
    implements ObjectArray<T> {
        private T[] array;
        private int max;

        SingleThread(int size) {
            this.array = new Object[size];
        }

        @Override
        public @UnknownNullability T get(int index) {
            T[] array = this.array;
            return index < array.length ? (T)array[index] : null;
        }

        @Override
        public void set(int index, @Nullable T object) {
            T[] array = this.array;
            if (index >= array.length) {
                int newLength = index * 2 + 1;
                this.array = array = Arrays.copyOf(array, newLength);
            }
            array[index] = object;
            this.max = Math.max(this.max, index);
        }

        @Override
        public void trim() {
            this.array = Arrays.copyOf(this.array, this.max + 1);
        }

        @Override
        public @UnknownNullability T @NotNull [] arrayCopy(@NotNull Class<T> type) {
            return Arrays.copyOf(this.array, this.max + 1, (Class<? extends T[]>)type.arrayType());
        }
    }
}

