/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.identity;

import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minestom.server.utils.identity.NamedAndIdentifiedImpl;
import org.jetbrains.annotations.NotNull;

public interface NamedAndIdentified {
    @NotNull
    public static NamedAndIdentified empty() {
        return NamedAndIdentified.of(Component.empty(), UUID.randomUUID());
    }

    @NotNull
    public static NamedAndIdentified named(@NotNull String name) {
        return NamedAndIdentified.of(name, UUID.randomUUID());
    }

    @NotNull
    public static NamedAndIdentified named(@NotNull Component name) {
        return NamedAndIdentified.of(name, UUID.randomUUID());
    }

    @NotNull
    public static NamedAndIdentified identified(@NotNull UUID uuid) {
        return NamedAndIdentified.of(Component.empty(), uuid);
    }

    @NotNull
    public static NamedAndIdentified of(@NotNull String name, @NotNull UUID uuid) {
        return new NamedAndIdentifiedImpl(name, uuid);
    }

    @NotNull
    public static NamedAndIdentified of(@NotNull Component name, @NotNull UUID uuid) {
        return new NamedAndIdentifiedImpl(name, uuid);
    }

    @NotNull
    public Component getName();

    @NotNull
    public UUID getUuid();
}

