/*
 * Decompiled with CFR 0.152.
 */
package net.uebliche.polarconverter.mixin;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.hollowcube.polar.AnvilPolar;
import net.hollowcube.polar.ChunkSelector;
import net.hollowcube.polar.PolarWorld;
import net.hollowcube.polar.PolarWriter;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5218;
import net.minecraft.class_524;
import net.minecraft.class_8021;
import net.minecraft.class_8667;
import net.minestom.server.MinecraftServer;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_524.class})
public class EditWorldScreenMixin
extends class_437 {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Shadow
    @Final
    private class_8667 field_46896;
    @Shadow
    @Final
    private class_32.class_5143 field_23777;

    protected EditWorldScreenMixin() {
        super((class_2561)class_2561.method_43473());
    }

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/DirectionalLayoutWidget;add(Lnet/minecraft/client/gui/widget/Widget;)Lnet/minecraft/client/gui/widget/Widget;", ordinal=9)})
    private void addConvertToPolarButton(class_310 client, class_32.class_5143 session, String levelName, BooleanConsumer callback, CallbackInfo ci) {
        this.field_46896.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Convert to Polar"), button -> {
            button.method_25355((class_2561)class_2561.method_43470((String)"Processing..."));
            button.field_22763 = false;
            new Thread(() -> {
                MinecraftServer.init();
                if (this.convertToPolar(session.method_54543().comp_732(), Path.of(session.method_54543().comp_732().toString(), session.method_27005() + ".polar")).booleanValue()) {
                    class_310.method_1551().method_20493(() -> class_310.method_1551().method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47584, class_2561.method_30163((String)"Polar Converter Finished!!"), class_2561.method_30163((String)"World Folder Opened..."))));
                    class_156.method_668().method_672(session.method_27010(class_5218.field_24188).toFile());
                } else {
                    class_310.method_1551().method_20493(() -> class_310.method_1551().method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47584, class_2561.method_30163((String)"Polar Converter FAILED!!"), class_2561.method_30163((String)"please check console."))));
                }
                MinecraftServer.stopCleanly();
                button.method_25355((class_2561)class_2561.method_43470((String)"Convert to Polar"));
                button.field_22763 = true;
            }).start();
        }).method_46432(200).method_46431());
    }

    @Unique
    public Boolean convertToPolar(Path anvilPath, Path outputPath) {
        PolarWorld polarWorld;
        try {
            polarWorld = AnvilPolar.anvilToPolar(anvilPath, ChunkSelector.all());
        }
        catch (IOException e) {
            LOGGER.warn("Fail to read world", e);
            return false;
        }
        byte[] result = PolarWriter.write(polarWorld);
        try {
            Files.write(outputPath, result, new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            LOGGER.warn("Fail to save world", e);
            return false;
        }
    }
}

