/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.adventure.bossbar;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.bossbar.BossBar;
import net.minestom.server.adventure.bossbar.BossBarHolder;
import net.minestom.server.adventure.bossbar.BossBarListener;
import net.minestom.server.entity.Player;
import net.minestom.server.utils.PacketSendingUtils;
import org.jetbrains.annotations.NotNull;

public class BossBarManager {
    private final BossBarListener listener = new BossBarListener(this);
    private final Map<UUID, Set<BossBarHolder>> playerBars = new ConcurrentHashMap<UUID, Set<BossBarHolder>>();
    final Map<BossBar, BossBarHolder> bars = new ConcurrentHashMap<BossBar, BossBarHolder>();

    public void addBossBar(@NotNull Player player, @NotNull BossBar bar) {
        BossBarHolder holder = this.getOrCreateHandler(bar);
        if (holder.addViewer(player)) {
            player.sendPacket(holder.createAddPacket());
            this.playerBars.computeIfAbsent(player.getUuid(), uuid -> new HashSet()).add(holder);
        }
    }

    public void removeBossBar(@NotNull Player player, @NotNull BossBar bar) {
        BossBarHolder holder = this.bars.get(bar);
        if (holder != null && holder.removeViewer(player)) {
            player.sendPacket(holder.createRemovePacket());
            this.removePlayer(player, holder);
        }
    }

    public void addBossBar(@NotNull Collection<Player> players, @NotNull BossBar bar) {
        BossBarHolder holder = this.getOrCreateHandler(bar);
        List<Player> addedPlayers = players.stream().filter(holder::addViewer).toList();
        if (!addedPlayers.isEmpty()) {
            PacketSendingUtils.sendGroupedPacket(addedPlayers, holder.createAddPacket());
        }
    }

    public void removeBossBar(@NotNull Collection<Player> players, @NotNull BossBar bar) {
        BossBarHolder holder = this.bars.get(bar);
        if (holder != null) {
            List<Player> removedPlayers = players.stream().filter(holder::removeViewer).toList();
            if (!removedPlayers.isEmpty()) {
                PacketSendingUtils.sendGroupedPacket(removedPlayers, holder.createRemovePacket());
            }
        }
    }

    public void destroyBossBar(@NotNull BossBar bossBar) {
        BossBarHolder holder = this.bars.remove(bossBar);
        if (holder != null) {
            PacketSendingUtils.sendGroupedPacket(holder.players, holder.createRemovePacket());
            for (Player player : holder.players) {
                this.removePlayer(player, holder);
            }
        }
    }

    public void removeAllBossBars(@NotNull Player player) {
        Set<BossBarHolder> holders = this.playerBars.remove(player.getUuid());
        if (holders != null) {
            for (BossBarHolder holder : holders) {
                holder.removeViewer(player);
            }
        }
    }

    @NotNull
    public Collection<BossBar> getPlayerBossBars(@NotNull Player player) {
        Collection holders = this.playerBars.get(player.getUuid());
        return holders != null ? holders.stream().map(holder -> holder.bar).toList() : List.of();
    }

    @NotNull
    public Collection<Player> getBossBarViewers(@NotNull BossBar bossBar) {
        BossBarHolder holder = this.bars.get(bossBar);
        return holder != null ? Collections.unmodifiableCollection(holder.players) : List.of();
    }

    @NotNull
    private BossBarHolder getOrCreateHandler(@NotNull BossBar bar) {
        return this.bars.computeIfAbsent(bar, bossBar -> {
            BossBarHolder holder = new BossBarHolder((BossBar)bossBar);
            bossBar.addListener(this.listener);
            return holder;
        });
    }

    private void removePlayer(Player player, BossBarHolder holder) {
        Set<BossBarHolder> holders = this.playerBars.get(player.getUuid());
        if (holders != null) {
            holders.remove(holder);
            if (holders.isEmpty()) {
                this.playerBars.remove(player.getUuid());
            }
        }
    }
}

