/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.damage;

import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.entity.damage.DamageTypeImpl;
import net.minestom.server.entity.damage.DamageTypes;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryData;
import net.minestom.server.registry.RegistryKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public sealed interface DamageType
extends DamageTypes
permits DamageTypeImpl {
    @NotNull
    public static final Codec<DamageType> REGISTRY_CODEC = StructCodec.struct("exhaustion", Codec.FLOAT, DamageType::exhaustion, "message_id", Codec.STRING, DamageType::messageId, "scaling", Codec.STRING, DamageType::scaling, DamageType::create);
    @NotNull
    public static final Codec<RegistryKey<DamageType>> CODEC = RegistryKey.codec(Registries::damageType);

    @NotNull
    public static DamageType create(float exhaustion, @NotNull String messageId, @NotNull String scaling) {
        return new DamageTypeImpl(exhaustion, messageId, scaling);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<DamageType> createDefaultRegistry() {
        return DynamicRegistry.create(Key.key("minecraft:damage_type"), REGISTRY_CODEC, RegistryData.Resource.DAMAGE_TYPES);
    }

    public float exhaustion();

    @NotNull
    public String messageId();

    @NotNull
    public String scaling();

    public static final class Builder {
        private float exhaustion = 0.0f;
        private String messageId;
        private String scaling;

        private Builder() {
        }

        @NotNull
        public Builder exhaustion(float exhaustion) {
            this.exhaustion = exhaustion;
            return this;
        }

        @NotNull
        public Builder messageId(@NotNull String messageId) {
            this.messageId = messageId;
            return this;
        }

        @NotNull
        public Builder scaling(@NotNull String scaling) {
            this.scaling = scaling;
            return this;
        }

        @NotNull
        public DamageType build() {
            return new DamageTypeImpl(this.exhaustion, this.messageId, this.scaling);
        }
    }
}

