/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.animal;

import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.entity.metadata.animal.CowVariantImpl;
import net.minestom.server.entity.metadata.animal.CowVariants;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryData;
import net.minestom.server.registry.RegistryKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public sealed interface CowVariant
extends CowVariants
permits CowVariantImpl {
    @NotNull
    public static final Codec<CowVariant> REGISTRY_CODEC = StructCodec.struct("model", Model.CODEC.optional(Model.NORMAL), CowVariant::model, "asset_id", Codec.KEY, CowVariant::assetId, CowVariantImpl::new);
    @NotNull
    public static final NetworkBuffer.Type<RegistryKey<CowVariant>> NETWORK_TYPE = RegistryKey.networkType(Registries::cowVariant);
    @NotNull
    public static final Codec<RegistryKey<CowVariant>> CODEC = RegistryKey.codec(Registries::cowVariant);

    @NotNull
    public static CowVariant create(@NotNull Model model, @NotNull Key assetId) {
        return new CowVariantImpl(model, assetId);
    }

    @ApiStatus.Internal
    public static DynamicRegistry<CowVariant> createDefaultRegistry() {
        return DynamicRegistry.create(Key.key("minecraft:cow_variant"), REGISTRY_CODEC, RegistryData.Resource.COW_VARIANTS);
    }

    @NotNull
    public Model model();

    @NotNull
    public Key assetId();

    public static enum Model {
        NORMAL,
        COLD,
        WARM;

        public static final Codec<Model> CODEC;

        static {
            CODEC = Codec.Enum(Model.class);
        }
    }
}

