/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.animal.tameable;

import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.entity.metadata.animal.tameable.WolfVariantImpl;
import net.minestom.server.entity.metadata.animal.tameable.WolfVariants;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryData;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public sealed interface WolfVariant
extends WolfVariants
permits WolfVariantImpl {
    public static final Codec<WolfVariant> REGISTRY_CODEC = StructCodec.struct("assets", Assets.CODEC, WolfVariant::assets, WolfVariantImpl::new);
    @NotNull
    public static final NetworkBuffer.Type<RegistryKey<WolfVariant>> NETWORK_TYPE = RegistryKey.networkType(Registries::wolfVariant);
    @NotNull
    public static final Codec<RegistryKey<WolfVariant>> CODEC = RegistryKey.codec(Registries::wolfVariant);

    @NotNull
    public static WolfVariant create(@NotNull Assets assets) {
        return new WolfVariantImpl(assets);
    }

    @NotNull
    public static WolfVariant create(@NotNull Key wild, @NotNull Key tame, @NotNull Key angry) {
        return new WolfVariantImpl(new Assets(wild, tame, angry));
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    public static DynamicRegistry<WolfVariant> createDefaultRegistry() {
        return DynamicRegistry.create(Key.key("minecraft:wolf_variant"), REGISTRY_CODEC, RegistryData.Resource.WOLF_VARIANTS);
    }

    @NotNull
    public Assets assets();

    public record Assets(@NotNull Key wild, @NotNull Key tame, @NotNull Key angry) {
        public static final Codec<Assets> CODEC = StructCodec.struct("wild", Codec.KEY, Assets::wild, "tame", Codec.KEY, Assets::tame, "angry", Codec.KEY, Assets::angry, Assets::new);

        public Assets(@NotNull Key wild, @NotNull Key tame, @NotNull Key angry) {
            Check.notNull(wild, "missing wild asset");
            Check.notNull(tame, "missing tame asset");
            Check.notNull(angry, "missing angry asset");
        }
    }

    public static final class Builder {
        private Assets assets;
        private Key wildAsset;
        private Key tameAsset;
        private Key angryAsset;

        private Builder() {
        }

        @NotNull
        public Builder wildAsset(@NotNull Key wildAsset) {
            this.wildAsset = wildAsset;
            return this;
        }

        @NotNull
        public Builder tameAsset(@NotNull Key tameAsset) {
            this.tameAsset = tameAsset;
            return this;
        }

        @NotNull
        public Builder angryAsset(@NotNull Key angryAsset) {
            this.angryAsset = angryAsset;
            return this;
        }

        @NotNull
        public Builder assets(@NotNull Assets assets) {
            this.assets = assets;
            return this;
        }

        @NotNull
        public WolfVariant build() {
            Assets assets = Objects.requireNonNullElseGet(this.assets, () -> new Assets(this.wildAsset, this.tameAsset, this.angryAsset));
            return new WolfVariantImpl(assets);
        }
    }
}

