/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.pathfinding.generators;

import java.util.Collection;
import java.util.OptionalDouble;
import java.util.Set;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.collision.CollisionUtils;
import net.minestom.server.collision.PhysicsResult;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.pathfinding.PNode;
import net.minestom.server.instance.block.Block;
import org.jetbrains.annotations.NotNull;

public interface NodeGenerator {
    @NotNull
    public Collection<? extends PNode> getWalkable(@NotNull Block.Getter var1, @NotNull Set<PNode> var2, @NotNull PNode var3, @NotNull Point var4, @NotNull BoundingBox var5);

    public boolean hasGravitySnap();

    @NotNull
    public OptionalDouble gravitySnap(@NotNull Block.Getter var1, double var2, double var4, double var6, @NotNull BoundingBox var8, double var9);

    default public boolean canMoveTowards(@NotNull Block.Getter getter, @NotNull Point start, @NotNull Point end, @NotNull BoundingBox boundingBox) {
        Point diff = end.sub(start);
        if (getter.getBlock(end) != Block.AIR) {
            return false;
        }
        PhysicsResult res = CollisionUtils.handlePhysics(getter, boundingBox, Pos.fromPoint(start), Vec.fromPoint(diff), null, false);
        return !res.collisionZ() && !res.collisionY() && !res.collisionX();
    }

    default public boolean pointInvalid(@NotNull Block.Getter getter, @NotNull Point point, @NotNull BoundingBox boundingBox) {
        BoundingBox.PointIterator iterator = boundingBox.getBlocks(point);
        while (iterator.hasNext()) {
            BoundingBox.MutablePoint block = iterator.next();
            if (!getter.getBlock(block.blockX(), block.blockY(), block.blockZ(), Block.Getter.Condition.TYPE).isSolid()) continue;
            return true;
        }
        return false;
    }

    default public double heuristic(@NotNull Point node, @NotNull Point target) {
        return node.distance(target);
    }
}

