/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event.player;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.Set;
import net.minestom.server.FeatureFlag;
import net.minestom.server.entity.Player;
import net.minestom.server.event.trait.PlayerEvent;
import net.minestom.server.instance.Instance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncPlayerConfigurationEvent
implements PlayerEvent {
    private final Player player;
    private final boolean isFirstConfig;
    private final ObjectArraySet<FeatureFlag> featureFlags = new ObjectArraySet();
    private boolean hardcore;
    private boolean clearChat;
    private boolean sendRegistryData;
    private Instance spawningInstance;

    public AsyncPlayerConfigurationEvent(@NotNull Player player, boolean isFirstConfig) {
        this.player = player;
        this.isFirstConfig = isFirstConfig;
        this.featureFlags.add(FeatureFlag.VANILLA);
        this.hardcore = false;
        this.clearChat = false;
        this.sendRegistryData = isFirstConfig;
        this.spawningInstance = null;
    }

    @Override
    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    public boolean isFirstConfig() {
        return this.isFirstConfig;
    }

    public boolean isHardcore() {
        return this.hardcore;
    }

    public void setHardcore(boolean hardcore) {
        this.hardcore = hardcore;
    }

    public void addFeatureFlag(@NotNull FeatureFlag feature) {
        this.featureFlags.add(feature);
    }

    public boolean removeFeatureFlag(@NotNull FeatureFlag feature) {
        return this.featureFlags.remove(feature);
    }

    @NotNull
    public Set<FeatureFlag> getFeatureFlags() {
        return ObjectSets.unmodifiable(this.featureFlags);
    }

    public boolean willClearChat() {
        return this.clearChat;
    }

    public void setClearChat(boolean clearChat) {
        this.clearChat = clearChat;
    }

    public boolean willSendRegistryData() {
        return this.sendRegistryData;
    }

    public void setSendRegistryData(boolean sendRegistryData) {
        this.sendRegistryData = sendRegistryData;
    }

    @Nullable
    public Instance getSpawningInstance() {
        return this.spawningInstance;
    }

    public void setSpawningInstance(@Nullable Instance spawningInstance) {
        this.spawningInstance = spawningInstance;
    }
}

