/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.enchant;

import java.util.List;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponentMap;
import net.minestom.server.entity.EquipmentSlotGroup;
import net.minestom.server.item.Material;
import net.minestom.server.item.enchant.AttributeEffect;
import net.minestom.server.item.enchant.ConditionalEffect;
import net.minestom.server.item.enchant.DamageImmunityEffect;
import net.minestom.server.item.enchant.EffectComponent;
import net.minestom.server.item.enchant.EnchantmentImpl;
import net.minestom.server.item.enchant.Enchantments;
import net.minestom.server.item.enchant.EntityEffect;
import net.minestom.server.item.enchant.LocationEffect;
import net.minestom.server.item.enchant.TargetedConditionalEffect;
import net.minestom.server.item.enchant.ValueEffect;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryData;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.registry.RegistryTag;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface Enchantment
extends Enchantments
permits EnchantmentImpl {
    @NotNull
    public static final NetworkBuffer.Type<RegistryKey<Enchantment>> NETWORK_TYPE = RegistryKey.networkType(Registries::enchantment);
    @NotNull
    public static final Codec<RegistryKey<Enchantment>> CODEC = RegistryKey.codec(Registries::enchantment);
    @NotNull
    public static final Codec<Enchantment> REGISTRY_CODEC = StructCodec.struct("description", Codec.COMPONENT, Enchantment::description, "exclusive_set", RegistryTag.codec(Registries::enchantment).optional(RegistryTag.empty()), Enchantment::exclusiveSet, "supported_items", RegistryTag.codec(Registries::material), Enchantment::supportedItems, "primary_items", RegistryTag.codec(Registries::material).optional(), Enchantment::primaryItems, "weight", Codec.INT, Enchantment::weight, "max_level", Codec.INT, Enchantment::maxLevel, "min_cost", Cost.CODEC, Enchantment::minCost, "max_cost", Cost.CODEC, Enchantment::maxCost, "anvil_cost", Codec.INT, Enchantment::anvilCost, "slots", EquipmentSlotGroup.CODEC.list(), Enchantment::slots, "effects", EffectComponent.CODEC.optional(DataComponentMap.EMPTY), Enchantment::effects, EnchantmentImpl::new);

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<Enchantment> createDefaultRegistry(@NotNull Registries registries) {
        return DynamicRegistry.createForEnchantmentsWithSelfReferentialLoadingNightmare(Key.key("minecraft:enchantment"), REGISTRY_CODEC, RegistryData.Resource.ENCHANTMENTS, registries);
    }

    @NotNull
    public Component description();

    @NotNull
    public RegistryTag<Enchantment> exclusiveSet();

    @NotNull
    public RegistryTag<Material> supportedItems();

    @Nullable
    public RegistryTag<Material> primaryItems();

    public int weight();

    public int maxLevel();

    @NotNull
    public Cost minCost();

    @NotNull
    public Cost maxCost();

    public int anvilCost();

    @NotNull
    public List<EquipmentSlotGroup> slots();

    @NotNull
    public DataComponentMap effects();

    public static class Builder {
        private Component description = Component.empty();
        private RegistryTag<Enchantment> exclusiveSet = RegistryTag.empty();
        private RegistryTag<Material> supportedItems = RegistryTag.empty();
        private RegistryTag<Material> primaryItems = RegistryTag.empty();
        private int weight = 1;
        private int maxLevel = 1;
        private Cost minCost = Cost.DEFAULT;
        private Cost maxCost = Cost.DEFAULT;
        private int anvilCost = 0;
        private List<EquipmentSlotGroup> slots = List.of();
        private DataComponentMap.Builder effects = DataComponentMap.builder();

        private Builder() {
        }

        @NotNull
        public Builder description(@NotNull Component description) {
            this.description = description;
            return this;
        }

        @NotNull
        public Builder exclusiveSet(@NotNull RegistryTag<Enchantment> exclusiveSet) {
            this.exclusiveSet = exclusiveSet;
            return this;
        }

        @NotNull
        public Builder supportedItems(@NotNull RegistryTag<Material> supportedItems) {
            this.supportedItems = supportedItems;
            return this;
        }

        @NotNull
        public Builder primaryItems(@NotNull RegistryTag<Material> primaryItems) {
            this.primaryItems = primaryItems;
            return this;
        }

        @NotNull
        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        @NotNull
        public Builder maxLevel(int maxLevel) {
            this.maxLevel = maxLevel;
            return this;
        }

        @NotNull
        public Builder minCost(int base, int perLevelAboveFirst) {
            return this.minCost(new Cost(base, perLevelAboveFirst));
        }

        @NotNull
        public Builder minCost(@NotNull Cost minCost) {
            this.minCost = minCost;
            return this;
        }

        @NotNull
        public Builder maxCost(int base, int perLevelAboveFirst) {
            return this.maxCost(new Cost(base, perLevelAboveFirst));
        }

        @NotNull
        public Builder maxCost(@NotNull Cost maxCost) {
            this.maxCost = maxCost;
            return this;
        }

        @NotNull
        public Builder anvilCost(int anvilCost) {
            this.anvilCost = anvilCost;
            return this;
        }

        @NotNull
        public Builder slots(EquipmentSlotGroup ... slots) {
            this.slots = List.of(slots);
            return this;
        }

        @NotNull
        public Builder slots(@NotNull List<EquipmentSlotGroup> slots) {
            this.slots = slots;
            return this;
        }

        @NotNull
        public <T> Builder effect(@NotNull DataComponent<T> component, @NotNull T value) {
            this.effects.set(component, value);
            return this;
        }

        @NotNull
        public Builder effects(@NotNull DataComponentMap effects) {
            this.effects = effects.toBuilder();
            return this;
        }

        @NotNull
        public Enchantment build() {
            return new EnchantmentImpl(this.description, this.exclusiveSet, this.supportedItems, this.primaryItems, this.weight, this.maxLevel, this.minCost, this.maxCost, this.anvilCost, this.slots, this.effects.build());
        }
    }

    public record Cost(int base, int perLevelAboveFirst) {
        public static final Cost DEFAULT = new Cost(1, 1);
        public static final Codec<Cost> CODEC = StructCodec.struct("base", Codec.INT, Cost::base, "per_level_above_first", Codec.INT, Cost::perLevelAboveFirst, Cost::new);
    }

    public static sealed interface Effect
    permits AttributeEffect, ConditionalEffect, DamageImmunityEffect, EntityEffect, LocationEffect, TargetedConditionalEffect, ValueEffect {
    }

    public static enum Target {
        ATTACKER,
        DAMAGING_ENTITY,
        VICTIM;

        public static final Codec<Target> CODEC;

        static {
            CODEC = Codec.Enum(Target.class);
        }
    }
}

