/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.NotNull;

public enum RecipeType implements StaticProtocolObject<RecipeType>
{
    CRAFTING(Key.key("minecraft:crafting")),
    SMELTING(Key.key("minecraft:smelting")),
    BLASTING(Key.key("minecraft:blasting")),
    SMOKING(Key.key("minecraft:smoking")),
    CAMPFIRE_COOKING(Key.key("minecraft:campfire_cooking")),
    STONECUTTING(Key.key("minecraft:stonecutting")),
    SMITHING(Key.key("minecraft:smithing"));

    private static final Map<Key, RecipeType> BY_KEY;
    public static final NetworkBuffer.Type<RecipeType> NETWORK_TYPE;
    public static final Codec<RecipeType> CODEC;
    private final Key key;

    private RecipeType(Key key) {
        this.key = key;
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }

    static {
        BY_KEY = Arrays.stream(RecipeType.values()).collect(Collectors.toMap(RecipeType::key, Function.identity()));
        NETWORK_TYPE = NetworkBuffer.Enum(RecipeType.class);
        CODEC = Codec.KEY.transform(BY_KEY::get, RecipeType::key);
    }
}

