/*
 * Decompiled with CFR 0.152.
 */
package net.hollowcube.polar;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.Collection;
import java.util.List;
import net.hollowcube.polar.PolarChunk;
import net.hollowcube.polar.WorldHeightUtil;
import net.minestom.server.coordinate.CoordConversion;
import net.minestom.server.world.DimensionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PolarWorld {
    public static final int MAGIC_NUMBER = 1349479538;
    public static final short LATEST_VERSION = 7;
    static final short VERSION_UNIFIED_LIGHT = 1;
    static final short VERSION_USERDATA_OPT_BLOCK_ENT_NBT = 2;
    static final short VERSION_MINESTOM_NBT_READ_BREAK = 3;
    static final short VERSION_WORLD_USERDATA = 4;
    static final short VERSION_SHORT_GRASS = 5;
    static final short VERSION_DATA_CONVERTER = 6;
    static final short VERSION_IMPROVED_LIGHT = 7;
    public static CompressionType DEFAULT_COMPRESSION = CompressionType.ZSTD;
    private final short version;
    private final int dataVersion;
    private CompressionType compression;
    private byte minSection;
    private byte maxSection;
    private byte @NotNull [] userData;
    private final Long2ObjectMap<PolarChunk> chunks = new Long2ObjectOpenHashMap<PolarChunk>();

    public PolarWorld() {
        this(7, 4325, DEFAULT_COMPRESSION, -4, 19, new byte[0], List.of());
    }

    public PolarWorld(@NotNull DimensionType dimensionType) {
        this(7, 4325, DEFAULT_COMPRESSION, (byte)(dimensionType.minY() / 16), (byte)(dimensionType.maxY() / 16 - 1), new byte[0], List.of());
    }

    public PolarWorld(short version, int dataVersion, @NotNull CompressionType compression, byte minSection, byte maxSection, byte @NotNull [] userData, @NotNull List<PolarChunk> chunks) {
        this.version = version;
        this.dataVersion = dataVersion;
        this.compression = compression;
        this.minSection = minSection;
        this.maxSection = maxSection;
        this.userData = userData;
        for (PolarChunk chunk : chunks) {
            long index = CoordConversion.chunkIndex(chunk.x(), chunk.z());
            this.chunks.put(index, chunk);
        }
    }

    public short version() {
        return this.version;
    }

    public int dataVersion() {
        return this.dataVersion;
    }

    @NotNull
    public CompressionType compression() {
        return this.compression;
    }

    public void setCompression(@NotNull CompressionType compression) {
        this.compression = compression;
    }

    public byte minSection() {
        return this.minSection;
    }

    public byte maxSection() {
        return this.maxSection;
    }

    public void setSectionCount(byte minSection, byte maxSection) {
        LongIterator longIterator = this.chunks.keySet().iterator();
        while (longIterator.hasNext()) {
            long l = (Long)longIterator.next();
            this.chunks.put(l, WorldHeightUtil.updateChunkHeight((PolarChunk)this.chunks.get(l), minSection, maxSection));
        }
        this.minSection = minSection;
        this.maxSection = maxSection;
    }

    public byte @NotNull [] userData() {
        return this.userData;
    }

    public void userData(byte @NotNull [] userData) {
        this.userData = userData;
    }

    @Nullable
    public PolarChunk chunkAt(int x, int z) {
        return this.chunks.getOrDefault(CoordConversion.chunkIndex(x, z), (PolarChunk)null);
    }

    public void updateChunkAt(int x, int z, @NotNull PolarChunk chunk) {
        this.chunks.put(CoordConversion.chunkIndex(x, z), chunk);
    }

    @NotNull
    public Collection<PolarChunk> chunks() {
        return this.chunks.values();
    }

    public static enum CompressionType {
        NONE,
        ZSTD;

        private static final CompressionType[] VALUES;

        @Nullable
        public static CompressionType fromId(int id) {
            if (id < 0 || id >= VALUES.length) {
                return null;
            }
            return VALUES[id];
        }

        static {
            VALUES = CompressionType.values();
        }
    }
}

