/*
 * Decompiled with CFR 0.152.
 */
package net.hollowcube.polar;

import net.hollowcube.polar.PolarLoader;
import net.minestom.server.MinecraftServer;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.world.biome.Biome;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PolarWorldAccess {
    public static final PolarWorldAccess DEFAULT = new PolarWorldAccess(){};

    default public void loadWorldData(@NotNull Instance instance, @Nullable NetworkBuffer userData) {
    }

    default public void saveWorldData(@NotNull Instance instance, @NotNull NetworkBuffer userData) {
    }

    default public void loadChunkData(@NotNull Chunk chunk, @Nullable NetworkBuffer userData) {
    }

    default public void saveChunkData(@NotNull Chunk chunk, @NotNull NetworkBuffer userData) {
    }

    @ApiStatus.Experimental
    default public void loadHeightmaps(@NotNull Chunk chunk, int[][] heightmaps) {
    }

    @ApiStatus.Experimental
    default public void saveHeightmaps(@NotNull Chunk chunk, int[][] heightmaps) {
    }

    default public int getBiomeId(@NotNull String name) {
        DynamicRegistry<Biome> biomeRegistry = MinecraftServer.getBiomeRegistry();
        return biomeRegistry.getId(DynamicRegistry.Key.of(name));
    }

    @NotNull
    default public String getBiomeName(int id) {
        DynamicRegistry<Biome> biomeRegistry = MinecraftServer.getBiomeRegistry();
        DynamicRegistry.Key<Biome> biome = biomeRegistry.getKey((Biome)id);
        if (biome == null) {
            PolarLoader.logger.error("Failed to find biome: {}", (Object)id);
            return Biome.PLAINS.name();
        }
        return biome.name();
    }
}

