/*
 * Decompiled with CFR 0.152.
 */
package net.hollowcube.polar;

import com.github.luben.zstd.Zstd;
import java.util.Arrays;
import net.hollowcube.polar.PaletteUtil;
import net.hollowcube.polar.PolarChunk;
import net.hollowcube.polar.PolarDataConverter;
import net.hollowcube.polar.PolarSection;
import net.hollowcube.polar.PolarWorld;
import net.minestom.server.coordinate.CoordConversion;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;

public class PolarWriter {
    private PolarWriter() {
    }

    public static byte[] write(@NotNull PolarWorld world) {
        return PolarWriter.write(world, PolarDataConverter.NOOP);
    }

    public static byte[] write(@NotNull PolarWorld world, @NotNull PolarDataConverter dataConverter) {
        byte[] contentBytes = NetworkBuffer.makeArray(content -> {
            content.write(NetworkBuffer.BYTE, world.minSection());
            content.write(NetworkBuffer.BYTE, world.maxSection());
            content.write(NetworkBuffer.BYTE_ARRAY, world.userData());
            content.write(NetworkBuffer.VAR_INT, world.chunks().size());
            for (PolarChunk chunk : world.chunks()) {
                PolarWriter.writeChunk(content, chunk, world.maxSection() - world.minSection() + 1);
            }
        });
        return NetworkBuffer.makeArray(buffer -> {
            buffer.write(NetworkBuffer.INT, 1349479538);
            buffer.write(NetworkBuffer.SHORT, (short)7);
            buffer.write(NetworkBuffer.VAR_INT, dataConverter.dataVersion());
            buffer.write(NetworkBuffer.BYTE, (byte)world.compression().ordinal());
            switch (world.compression()) {
                case NONE: {
                    buffer.write(NetworkBuffer.VAR_INT, contentBytes.length);
                    buffer.write(NetworkBuffer.RAW_BYTES, contentBytes);
                    break;
                }
                case ZSTD: {
                    buffer.write(NetworkBuffer.VAR_INT, contentBytes.length);
                    buffer.write(NetworkBuffer.RAW_BYTES, Zstd.compress(contentBytes));
                }
            }
        });
    }

    private static void writeChunk(@NotNull NetworkBuffer buffer, @NotNull PolarChunk chunk, int sectionCount) {
        buffer.write(NetworkBuffer.VAR_INT, chunk.x());
        buffer.write(NetworkBuffer.VAR_INT, chunk.z());
        assert (sectionCount == chunk.sections().length) : "section count and chunk section length mismatch";
        for (PolarSection section : chunk.sections()) {
            PolarWriter.writeSection(buffer, section);
        }
        buffer.write(NetworkBuffer.VAR_INT, chunk.blockEntities().size());
        for (PolarChunk.BlockEntity blockEntity : chunk.blockEntities()) {
            PolarWriter.writeBlockEntity(buffer, blockEntity);
        }
        int heightmapBits = 0;
        for (int i = 0; i < 32; ++i) {
            if (chunk.heightmap(i) == null) continue;
            heightmapBits |= 1 << i;
        }
        buffer.write(NetworkBuffer.INT, heightmapBits);
        int bitsPerEntry = PaletteUtil.bitsToRepresent(sectionCount * 16);
        for (int i = 0; i < 32; ++i) {
            int[] heightmap = chunk.heightmap(i);
            if (heightmap == null) continue;
            if (heightmap.length == 0) {
                buffer.write(NetworkBuffer.LONG_ARRAY, new long[0]);
                continue;
            }
            buffer.write(NetworkBuffer.LONG_ARRAY, PaletteUtil.pack(heightmap, bitsPerEntry));
        }
        buffer.write(NetworkBuffer.BYTE_ARRAY, chunk.userData());
    }

    private static void writeSection(@NotNull NetworkBuffer buffer, @NotNull PolarSection section) {
        buffer.write(NetworkBuffer.BOOLEAN, section.isEmpty());
        if (section.isEmpty()) {
            return;
        }
        String[] blockPalette = section.blockPalette();
        buffer.write(NetworkBuffer.STRING.list(), Arrays.asList(blockPalette));
        if (blockPalette.length > 1) {
            int[] blockData = section.blockData();
            int bitsPerEntry = (int)Math.ceil(Math.log(blockPalette.length) / Math.log(2.0));
            if (bitsPerEntry < 1) {
                bitsPerEntry = 1;
            }
            buffer.write(NetworkBuffer.LONG_ARRAY, PaletteUtil.pack(blockData, bitsPerEntry));
        }
        String[] biomePalette = section.biomePalette();
        buffer.write(NetworkBuffer.STRING.list(), Arrays.asList(biomePalette));
        if (biomePalette.length > 1) {
            int[] biomeData = section.biomeData();
            int bitsPerEntry = (int)Math.ceil(Math.log(biomePalette.length) / Math.log(2.0));
            if (bitsPerEntry < 1) {
                bitsPerEntry = 1;
            }
            buffer.write(NetworkBuffer.LONG_ARRAY, PaletteUtil.pack(biomeData, bitsPerEntry));
        }
        buffer.write(NetworkBuffer.BYTE, (byte)section.blockLightContent().ordinal());
        if (section.blockLightContent() == PolarSection.LightContent.PRESENT) {
            buffer.write(NetworkBuffer.RAW_BYTES, section.blockLight());
        }
        buffer.write(NetworkBuffer.BYTE, (byte)section.skyLightContent().ordinal());
        if (section.skyLightContent() == PolarSection.LightContent.PRESENT) {
            buffer.write(NetworkBuffer.RAW_BYTES, section.skyLight());
        }
    }

    private static void writeBlockEntity(@NotNull NetworkBuffer buffer, @NotNull PolarChunk.BlockEntity blockEntity) {
        int index = CoordConversion.chunkBlockIndex(blockEntity.x(), blockEntity.y(), blockEntity.z());
        buffer.write(NetworkBuffer.INT, index);
        buffer.write(NetworkBuffer.STRING.optional(), blockEntity.id());
        buffer.write(NetworkBuffer.NBT.optional(), blockEntity.data());
    }
}

