/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import net.minestom.server.adventure.audience.PacketGroupingAudience;
import net.minestom.server.entity.Player;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.utils.PacketSendingUtils;
import org.jetbrains.annotations.NotNull;

public interface Viewable {
    public boolean addViewer(@NotNull Player var1);

    public boolean removeViewer(@NotNull Player var1);

    @NotNull
    public @NotNull Set<@NotNull Player> getViewers();

    default public boolean isViewer(@NotNull Player player) {
        return this.getViewers().contains(player);
    }

    default public void sendPacketToViewers(@NotNull SendablePacket packet) {
        if (packet instanceof ServerPacket) {
            ServerPacket serverPacket = (ServerPacket)packet;
            PacketSendingUtils.sendGroupedPacket(this.getViewers(), serverPacket);
        } else {
            this.getViewers().forEach(player -> player.sendPacket(packet));
        }
    }

    default public void sendPacketsToViewers(@NotNull Collection<SendablePacket> packets) {
        packets.forEach(this::sendPacketToViewers);
    }

    default public void sendPacketsToViewers(SendablePacket ... packets) {
        this.sendPacketsToViewers(List.of(packets));
    }

    default public void sendPacketToViewersAndSelf(@NotNull SendablePacket packet) {
        this.sendPacketToViewers(packet);
    }

    @NotNull
    default public Audience getViewersAsAudience() {
        return PacketGroupingAudience.of(this.getViewers());
    }

    @NotNull
    default public Iterable<? extends Audience> getViewersAsAudiences() {
        return this.getViewers();
    }
}

