/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.adventure.provider;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.text.event.DataComponentValue;
import net.kyori.adventure.text.event.DataComponentValueConverterRegistry;
import net.kyori.adventure.text.serializer.gson.GsonDataComponentValue;
import net.minestom.server.MinecraftServer;
import net.minestom.server.adventure.MinestomDataComponentValue;
import net.minestom.server.adventure.serializer.nbt.NbtDataComponentValue;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.component.DataComponent;
import net.minestom.server.registry.RegistryTranscoder;
import org.jetbrains.annotations.NotNull;

public class MinestomDataComponentValueConverterProvider
implements DataComponentValueConverterRegistry.Provider {
    @Override
    @NotNull
    public Key id() {
        return Key.key("minestom", "data_component_value_converter");
    }

    @Override
    @NotNull
    public Iterable<DataComponentValueConverterRegistry.Conversion<?, ?>> conversions() {
        return List.of(DataComponentValueConverterRegistry.Conversion.convert(GsonDataComponentValue.class, MinestomDataComponentValue.class, (key, gsonValue) -> {
            if (gsonValue instanceof DataComponentValue.Removed) {
                return MinestomDataComponentValue.removed();
            }
            DataComponent<?> component = DataComponent.fromKey(key);
            if (component == null) {
                throw new IllegalArgumentException("Unknown data component: " + String.valueOf(key));
            }
            Object value = component.decode(new RegistryTranscoder<JsonElement>(Transcoder.JSON, MinecraftServer.process()), gsonValue.element()).orElseThrow("failed to decode " + String.valueOf(key));
            return MinestomDataComponentValue.dataComponentValue(value);
        }), DataComponentValueConverterRegistry.Conversion.convert(MinestomDataComponentValue.class, GsonDataComponentValue.class, (key, minestomValue) -> {
            if (minestomValue instanceof DataComponentValue.Removed) {
                return GsonDataComponentValue.gsonDataComponentValue(JsonNull.INSTANCE);
            }
            DataComponent<?> component = DataComponent.fromKey(key);
            if (component == null) {
                throw new IllegalArgumentException("Unknown data component: " + String.valueOf(key));
            }
            JsonElement value = component.encode(new RegistryTranscoder<JsonElement>(Transcoder.JSON, MinecraftServer.process()), minestomValue.value()).orElseThrow("failed to encode " + String.valueOf(key));
            return GsonDataComponentValue.gsonDataComponentValue(value);
        }), DataComponentValueConverterRegistry.Conversion.convert(NbtDataComponentValue.class, MinestomDataComponentValue.class, (key, nbtValue) -> {
            if (nbtValue instanceof DataComponentValue.Removed) {
                return MinestomDataComponentValue.removed();
            }
            DataComponent<?> component = DataComponent.fromKey(key);
            if (component == null) {
                throw new IllegalArgumentException("Unknown data component: " + String.valueOf(key));
            }
            Object value = component.decode(new RegistryTranscoder<BinaryTag>(Transcoder.NBT, MinecraftServer.process()), nbtValue.value()).orElseThrow("failed to decode " + String.valueOf(key));
            return MinestomDataComponentValue.dataComponentValue(value);
        }), DataComponentValueConverterRegistry.Conversion.convert(MinestomDataComponentValue.class, NbtDataComponentValue.class, (key, minestomValue) -> {
            if (minestomValue instanceof DataComponentValue.Removed) {
                return NbtDataComponentValue.removed();
            }
            DataComponent<?> component = DataComponent.fromKey(key);
            if (component == null) {
                throw new IllegalArgumentException("Unknown data component: " + String.valueOf(key));
            }
            BinaryTag value = component.encode(new RegistryTranscoder<BinaryTag>(Transcoder.NBT, MinecraftServer.process()), minestomValue.value()).orElseThrow("failed to encode " + String.valueOf(key));
            return NbtDataComponentValue.nbtDataComponentValue(value);
        }));
    }
}

