/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.codec;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.Decoder;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.codec.TranscoderProxy;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.gamedata.DataPack;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryTranscoder;
import net.minestom.server.utils.ThrowingFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CodecImpl {
    CodecImpl() {
    }

    @Deprecated
    record IntAsStringImpl() implements Codec<String>
    {
        @Override
        @NotNull
        public <D> Result<String> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            return coder.getInt(value).mapResult(String::valueOf);
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable String value) {
            if (value == null) {
                return new Result.Error("null");
            }
            try {
                return new Result.Ok<D>(coder.createInt(Integer.parseInt(value)));
            }
            catch (NumberFormatException ignored) {
                return new Result.Error("not an integer: " + value);
            }
        }
    }

    record Vector3DImpl() implements Codec<Point>
    {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<Point> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            Double d;
            List list;
            Result listResult = coder.getList(value);
            if (!(listResult instanceof Result.Ok)) return listResult.cast();
            Result.Ok ok = (Result.Ok)listResult;
            try {
                List list2;
                list = list2 = (List)ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (list.size() != 3) {
                return new Result.Error<Point>("Invalid length for Vector, expected 3 but got " + list.size());
            }
            Result<Double> xResult = coder.getDouble(list.get(0));
            if (!(xResult instanceof Result.Ok)) return xResult.cast();
            ok = (Result.Ok)xResult;
            Double x = d = (Double)ok.value();
            Result<Double> yResult = coder.getDouble(list.get(1));
            if (!(yResult instanceof Result.Ok)) return yResult.cast();
            ok = (Result.Ok)yResult;
            Double y = d = (Double)ok.value();
            Result<Double> zResult = coder.getDouble(list.get(2));
            if (!(zResult instanceof Result.Ok)) return zResult.cast();
            ok = (Result.Ok)zResult;
            Double z = d = (Double)ok.value();
            return new Result.Ok<Point>(new Vec(x, y, z));
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable Point value) {
            if (value == null) {
                return new Result.Error("null");
            }
            Transcoder.ListBuilder<D> list = coder.createList(3);
            list.add(coder.createDouble(value.x()));
            list.add(coder.createDouble(value.y()));
            list.add(coder.createDouble(value.z()));
            return new Result.Ok<D>(list.build());
        }
    }

    record BlockPositionImpl() implements Codec<Point>
    {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<Point> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            int[] intArray;
            Result<int[]> intArrayResult = coder.getIntArray(value);
            if (!(intArrayResult instanceof Result.Ok)) return intArrayResult.cast();
            Result.Ok ok = (Result.Ok)intArrayResult;
            try {
                int[] nArray;
                intArray = nArray = (int[])ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (intArray.length == 3) return new Result.Ok<Point>(new Vec(intArray[0], intArray[1], intArray[2]));
            return new Result.Error<Point>("Invalid length for Point, expected 3 but got " + intArray.length);
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable Point value) {
            if (value == null) {
                return new Result.Error("null");
            }
            return new Result.Ok<D>(coder.createIntArray(new int[]{(int)value.x(), (int)value.y(), (int)value.z()}));
        }
    }

    record OrElseImpl<T>(@NotNull Codec<T> primary, @NotNull Codec<T> secondary) implements Codec<T>
    {
        @Override
        @NotNull
        public <D> Result<T> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            Result primaryResult = this.primary.decode(coder, value);
            if (primaryResult instanceof Result.Ok) {
                Result.Ok primaryOk = (Result.Ok)primaryResult;
                return primaryOk;
            }
            Result secondaryResult = this.secondary.decode(coder, value);
            if (secondaryResult instanceof Result.Ok) {
                Result.Ok secondaryOk = (Result.Ok)secondaryResult;
                return secondaryOk;
            }
            return primaryResult;
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable T value) {
            Result<D> primaryResult = this.primary.encode(coder, value);
            if (primaryResult instanceof Result.Ok) {
                Result.Ok primaryOk = (Result.Ok)primaryResult;
                return primaryOk;
            }
            Result<D> secondaryResult = this.secondary.encode(coder, value);
            if (secondaryResult instanceof Result.Ok) {
                Result.Ok secondaryOk = (Result.Ok)secondaryResult;
                return secondaryOk;
            }
            return primaryResult;
        }
    }

    static final class ForwardRefImpl<T>
    implements Codec<T> {
        private final Supplier<Codec<T>> delegateFunc;
        private Codec<T> delegate;

        ForwardRefImpl(Supplier<Codec<T>> delegateFunc) {
            this.delegateFunc = delegateFunc;
        }

        @Override
        @NotNull
        public <D> Result<T> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            if (this.delegate == null) {
                this.delegate = this.delegateFunc.get();
            }
            return this.delegate.decode(coder, value);
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable T value) {
            if (this.delegate == null) {
                this.delegate = this.delegateFunc.get();
            }
            return this.delegate.encode(coder, value);
        }
    }

    static final class RecursiveImpl<T>
    implements Codec<T> {
        final Codec<T> delegate;

        public RecursiveImpl(@NotNull Function<Codec<T>, Codec<T>> self) {
            this.delegate = self.apply(this);
        }

        @Override
        @NotNull
        public <D> Result<T> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            return this.delegate.decode(coder, value);
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable T value) {
            return this.delegate.encode(coder, value);
        }
    }

    record RegistryTaggedUnionImpl<T>(@NotNull Registries.Selector<StructCodec<? extends T>> registrySelector, @NotNull Function<T, StructCodec<? extends T>> valueToCodec, @NotNull String key) implements StructCodec<T>
    {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<T> decodeFromMap(@NotNull Transcoder<D> coder, @NotNull Transcoder.MapLike<D> map) {
            String tag;
            if (!(coder instanceof RegistryTranscoder)) {
                return new Result.Error("Missing registries in transcoder");
            }
            RegistryTranscoder context = (RegistryTranscoder)coder;
            DynamicRegistry<StructCodec<T>> registry = this.registrySelector.select(context.registries());
            Result type = map.getValue(this.key).map(coder::getString);
            if (!(type instanceof Result.Ok)) return type.mapError(e -> this.key + ": " + e).cast();
            Result.Ok ok = (Result.Ok)type;
            try {
                String string;
                tag = string = (String)ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            StructCodec<T> innerCodec = registry.get(Key.key(tag));
            if (innerCodec != null) return innerCodec.decodeFromMap(coder, map);
            return new Result.Error("No such key: " + tag);
        }

        @Override
        @NotNull
        public <D> Result<D> encodeToMap(@NotNull Transcoder<D> coder, @NotNull T value, @NotNull Transcoder.MapBuilder<D> map) {
            if (!(coder instanceof RegistryTranscoder)) {
                return new Result.Error("Missing registries in transcoder");
            }
            RegistryTranscoder context = (RegistryTranscoder)coder;
            DynamicRegistry<StructCodec<StructCodec<? extends T>>> registry = this.registrySelector.select(context.registries());
            StructCodec<T> innerCodec = this.valueToCodec.apply(value);
            DynamicRegistry.Key<StructCodec<T>> type = registry.getKey(innerCodec);
            if (type == null) {
                return new Result.Error("Unregistered serializer for: " + String.valueOf(value));
            }
            if (context.forClient() && registry.getPack(type) != DataPack.MINECRAFT_CORE) {
                return new Result.Ok<Object>(null);
            }
            map.put(this.key, coder.createString(type.name()));
            return innerCodec.encodeToMap(coder, value, map);
        }
    }

    record RegistryKeyImpl<T>(@NotNull Registries.Selector<T> selector) implements Codec<DynamicRegistry.Key<T>>
    {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<DynamicRegistry.Key<T>> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            String keyStr;
            if (!(coder instanceof RegistryTranscoder)) {
                return new Result.Error<DynamicRegistry.Key<T>>("Missing registries in transcoder");
            }
            RegistryTranscoder context = (RegistryTranscoder)coder;
            DynamicRegistry registry = this.selector.select(context.registries());
            Result<String> keyResult = coder.getString(value);
            if (!(keyResult instanceof Result.Ok)) return keyResult.cast();
            Result.Ok ok = (Result.Ok)keyResult;
            try {
                String string;
                keyStr = string = (String)ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            DynamicRegistry.Key key = DynamicRegistry.Key.of(Key.key(keyStr));
            if (registry.getId(key) != -1) return new Result.Ok(key);
            return new Result.Error<DynamicRegistry.Key<T>>("no registry value: " + String.valueOf(key));
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable DynamicRegistry.Key<T> value) {
            if (value == null) {
                return new Result.Error("null");
            }
            if (!(coder instanceof RegistryTranscoder)) {
                return new Result.Error("Missing registries in transcoder");
            }
            RegistryTranscoder context = (RegistryTranscoder)coder;
            DynamicRegistry<T> registry = this.selector.select(context.registries());
            if (registry.getId(value) == -1) {
                return new Result.Error("no registry value: " + String.valueOf(value));
            }
            return new Result.Ok<D>(coder.createString(value.name()));
        }
    }

    record UnionImpl<T, R, T1 extends T, TR extends R>(@NotNull String keyField, @NotNull Codec<T> keyCodec, @NotNull Function<T, StructCodec<TR>> serializers, @NotNull Function<R, T1> keyFunc) implements StructCodec<R>
    {
        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<R> decodeFromMap(@NotNull Transcoder<D> coder, @NotNull Transcoder.MapLike<D> map) {
            void key2;
            Result keyResult = map.getValue(this.keyField).map(key -> this.keyCodec.decode(coder, key));
            if (!(keyResult instanceof Result.Ok)) return keyResult.cast();
            Result.Ok ok = (Result.Ok)keyResult;
            try {
                Object t;
                Object key22 = t = ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return this.serializers.apply(key2).decodeFromMap(coder, map);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<D> encodeToMap(@NotNull Transcoder<D> coder, @NotNull R value, @NotNull Transcoder.MapBuilder<D> map) {
            Object keyValue;
            T1 key = this.keyFunc.apply(value);
            StructCodec<TR> serializer = this.serializers.apply(key);
            if (serializer == null) {
                return new Result.Error("no union value: " + String.valueOf(key));
            }
            Result<D> keyResult = this.keyCodec.encode(coder, key);
            if (!(keyResult instanceof Result.Ok)) return keyResult.cast();
            Result.Ok ok = (Result.Ok)keyResult;
            try {
                Object t;
                keyValue = t = ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (keyValue == null) {
                return new Result.Error("null");
            }
            map.put(this.keyField, keyValue);
            return serializer.encodeToMap(coder, value, map);
        }
    }

    record MapImpl<K, V>(@NotNull Codec<K> keyCodec, @NotNull Codec<V> valueCodec, int maxSize) implements Codec<Map<K, V>>
    {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<Map<K, V>> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            Transcoder.MapLike map;
            Result<Transcoder.MapLike<D>> mapResult = coder.getMap(value);
            if (!(mapResult instanceof Result.Ok)) return mapResult.cast();
            Result.Ok ok = (Result.Ok)mapResult;
            try {
                Transcoder.MapLike mapLike = (Transcoder.MapLike)ok.value();
                map = mapLike;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (map.size() > this.maxSize) {
                return new Result.Error<Map<K, V>>("Map size exceeds maximum allowed size: " + this.maxSize);
            }
            if (map.isEmpty()) {
                return new Result.Ok(Map.of());
            }
            HashMap decodedMap = new HashMap(map.size());
            for (String key : map.keys()) {
                Object t;
                Result keyResult = this.keyCodec.decode(coder, coder.createString(key));
                if (!(keyResult instanceof Result.Ok)) return keyResult.cast();
                ok = (Result.Ok)keyResult;
                Object decodedKey = t = ok.value();
                Result valueResult = this.valueCodec.decode(coder, map.getValue(key).orElseThrow());
                if (!(valueResult instanceof Result.Ok)) return valueResult.cast();
                ok = (Result.Ok)valueResult;
                Object decodedValue = t = ok.value();
                decodedMap.put(decodedKey, decodedValue);
            }
            return new Result.Ok(Map.copyOf(decodedMap));
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable Map<K, V> value) {
            if (value == null) {
                return new Result.Error("null");
            }
            if (value.size() > this.maxSize) {
                return new Result.Error("Map size exceeds maximum allowed size: " + this.maxSize);
            }
            if (value.isEmpty()) {
                return new Result.Ok<D>(coder.createMap().build());
            }
            Transcoder.MapBuilder map = coder.createMap();
            Iterator<Map.Entry<K, V>> iterator = value.entrySet().iterator();
            while (iterator.hasNext()) {
                Object encodedValue;
                Object encodedKey;
                Map.Entry<K, V> entry = iterator.next();
                Result<D> keyResult = this.keyCodec.encode(coder, entry.getKey());
                if (!(keyResult instanceof Result.Ok)) {
                    return keyResult.cast();
                }
                Result.Ok ok = (Result.Ok)keyResult;
                try {
                    Object t;
                    encodedKey = t = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Result<D> valueResult = this.valueCodec.encode(coder, entry.getValue());
                if (!(valueResult instanceof Result.Ok)) {
                    return valueResult.cast();
                }
                ok = (Result.Ok)valueResult;
                {
                    Object t;
                    encodedValue = t = ok.value();
                }
                map.put(encodedKey, encodedValue);
            }
            return new Result.Ok<D>(map.build());
        }
    }

    record SetImpl<T>(@NotNull Codec<T> inner, int maxSize) implements Codec<Set<T>>
    {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<Set<T>> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            List list;
            Result<List<D>> listResult = coder.getList(value);
            if (!(listResult instanceof Result.Ok)) return listResult.cast();
            Result.Ok ok = (Result.Ok)listResult;
            try {
                List list2 = (List)ok.value();
                list = list2;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (list.size() > this.maxSize) {
                return new Result.Error<Set<T>>("Set size exceeds maximum allowed size: " + this.maxSize);
            }
            HashSet decodedSet = new HashSet(list.size());
            for (Object item : list) {
                Object t;
                Result decodedItem = this.inner.decode(coder, item);
                if (!(decodedItem instanceof Result.Ok)) return decodedItem.cast();
                ok = (Result.Ok)decodedItem;
                Object valueItem = t = ok.value();
                decodedSet.add(valueItem);
            }
            return new Result.Ok<Set<T>>(Set.copyOf(decodedSet));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable Set<T> value) {
            if (value == null) {
                return new Result.Error("null");
            }
            if (value.size() > this.maxSize) {
                throw new IllegalArgumentException("List size exceeds maximum allowed size: " + this.maxSize);
            }
            Transcoder.ListBuilder encodedList = coder.createList(value.size());
            Iterator<T> iterator = value.iterator();
            while (iterator.hasNext()) {
                Object encodedItem;
                T item = iterator.next();
                Result<D> itemResult = this.inner.encode(coder, item);
                if (!(itemResult instanceof Result.Ok)) {
                    return itemResult.cast();
                }
                Result.Ok ok = (Result.Ok)itemResult;
                try {
                    Object t;
                    encodedItem = t = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                encodedList.add(encodedItem);
            }
            return new Result.Ok<D>(encodedList.build());
        }
    }

    record ListImpl<T>(@NotNull Codec<T> inner, int maxSize) implements Codec<List<T>>
    {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<List<T>> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            List list;
            Result<List<D>> listResult = coder.getList(value);
            if (!(listResult instanceof Result.Ok)) return listResult.cast();
            Result.Ok ok = (Result.Ok)listResult;
            try {
                List list2 = (List)ok.value();
                list = list2;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (list.size() > this.maxSize) {
                return new Result.Error<List<T>>("List size exceeds maximum allowed size: " + this.maxSize);
            }
            ArrayList decodedList = new ArrayList(list.size());
            for (Object item : list) {
                Object t;
                Result decodedItem = this.inner.decode(coder, item);
                if (!(decodedItem instanceof Result.Ok)) return decodedItem.cast();
                ok = (Result.Ok)decodedItem;
                Object valueItem = t = ok.value();
                decodedList.add(valueItem);
            }
            return new Result.Ok<List<T>>(List.copyOf(decodedList));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable List<T> value) {
            if (value == null) {
                return new Result.Error("null");
            }
            if (value.size() > this.maxSize) {
                throw new IllegalArgumentException("List size exceeds maximum allowed size: " + this.maxSize);
            }
            Transcoder.ListBuilder encodedList = coder.createList(value.size());
            Iterator<T> iterator = value.iterator();
            while (iterator.hasNext()) {
                Object encodedItem;
                T item = iterator.next();
                Result<D> itemResult = this.inner.encode(coder, item);
                if (!(itemResult instanceof Result.Ok)) {
                    return itemResult.cast();
                }
                Result.Ok ok = (Result.Ok)itemResult;
                try {
                    Object t;
                    encodedItem = t = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                if (encodedItem == null) continue;
                encodedList.add(encodedItem);
            }
            return new Result.Ok<D>(encodedList.build());
        }
    }

    record TransformImpl<T, S>(@NotNull Codec<T> inner, @NotNull ThrowingFunction<T, S> to, @NotNull ThrowingFunction<S, T> from) implements Codec<S>
    {
        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @NotNull
        public <D> Result<S> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            try {
                Record record;
                Result innerResult23322;
                Result result = innerResult23322 = this.inner.decode(coder, value);
                Objects.requireNonNull(result);
                Result result2 = result;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Result.Ok.class, Result.Error.class}, result2, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        Result.Ok ok = (Result.Ok)result2;
                        try {
                            Object t;
                            Object inner = t = ok.value();
                            record = new Result.Ok<S>(this.to.apply(inner));
                            return record;
                        }
                        catch (Throwable innerResult23322) {
                            throw new MatchException(innerResult23322.toString(), innerResult23322);
                        }
                    }
                    case 1: 
                }
                Result.Error error = (Result.Error)result2;
                {
                    String string;
                    String error2 = string = error.message();
                    record = new Result.Error(error2);
                }
                return record;
            }
            catch (Exception e) {
                return new Result.Error(e.getMessage());
            }
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable S value) {
            try {
                return this.inner.encode(coder, this.from.apply(value));
            }
            catch (Exception e) {
                return new Result.Error(e.getMessage());
            }
        }
    }

    record OptionalImpl<T>(@NotNull Codec<T> inner, @Nullable T defaultValue) implements Codec<T>
    {
        @Override
        @NotNull
        public <D> Result<T> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            return new Result.Ok(this.inner.decode(coder, value).orElse(this.defaultValue));
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable T value) {
            if (value == null || Objects.equals(value, this.defaultValue)) {
                return new Result.Ok<D>(coder.createNull());
            }
            return this.inner.encode(coder, value);
        }
    }

    record PrimitiveImpl<T>(@NotNull PrimitiveEncoder<T> encoder, @NotNull Decoder<T> decoder) implements Codec<T>
    {
        @Override
        @NotNull
        public <D> Result<T> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            return this.decoder.decode(coder, value);
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable T value) {
            if (value == null) {
                return new Result.Error("null");
            }
            return new Result.Ok<D>(this.encoder.encode(coder, value));
        }
    }

    static interface PrimitiveEncoder<T> {
        @NotNull
        public <D> D encode(@NotNull Transcoder<D> var1, @NotNull T var2);
    }

    record RawValueCodecImpl() implements Codec<Codec.RawValue>
    {
        @Override
        @NotNull
        public <D> Result<Codec.RawValue> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            return new Result.Ok<Codec.RawValue>(new RawValueImpl<D>(coder, value));
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable Codec.RawValue value) {
            if (value == null) {
                return new Result.Error("null");
            }
            return value.convertTo(coder);
        }
    }

    record RawValueImpl<D>(@NotNull Transcoder<D> coder, @NotNull D value) implements Codec.RawValue
    {
        RawValueImpl(@NotNull Transcoder<D> coder, @NotNull D value) {
            Objects.requireNonNull(coder);
            Objects.requireNonNull(value);
        }

        @NotNull
        public <D1> Result<D1> convertTo(@NotNull Transcoder<D1> coder) {
            if (TranscoderProxy.extractDelegate(this.coder) == TranscoderProxy.extractDelegate(coder)) {
                return new Result.Ok<D>(this.value);
            }
            return this.coder.convertTo(coder, this.value);
        }
    }
}

