/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments;

import java.util.ArrayList;
import java.util.List;
import net.minestom.server.command.ArgumentParserType;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.CommandContext;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import net.minestom.server.command.builder.parser.CommandParser;
import net.minestom.server.command.builder.parser.ValidSyntaxHolder;
import org.jetbrains.annotations.NotNull;

public class ArgumentGroup
extends Argument<CommandContext> {
    public static final int INVALID_ARGUMENTS_ERROR = 1;
    private final Argument<?>[] group;

    public ArgumentGroup(@NotNull String id, Argument<?> ... group) {
        super(id, true, false);
        this.group = group;
    }

    @Override
    @NotNull
    public CommandContext parse(@NotNull CommandSender sender, @NotNull String input) throws ArgumentSyntaxException {
        ArrayList<ValidSyntaxHolder> validSyntaxes = new ArrayList<ValidSyntaxHolder>();
        CommandParser.parse(sender, null, this.group, input.split(" "), input, validSyntaxes, null);
        CommandContext context = new CommandContext(input);
        CommandParser.findMostCorrectSyntax(validSyntaxes, context);
        if (validSyntaxes.isEmpty()) {
            throw new ArgumentSyntaxException("Invalid arguments", input, 1);
        }
        return context;
    }

    @Override
    public ArgumentParserType parser() {
        return null;
    }

    public List<Argument<?>> group() {
        return List.of(this.group);
    }
}

