/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event.item;

import net.minestom.server.entity.Player;
import net.minestom.server.entity.PlayerHand;
import net.minestom.server.event.trait.CancellableEvent;
import net.minestom.server.event.trait.ItemEvent;
import net.minestom.server.event.trait.PlayerInstanceEvent;
import net.minestom.server.item.ItemAnimation;
import net.minestom.server.item.ItemStack;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public class PlayerBeginItemUseEvent
implements PlayerInstanceEvent,
ItemEvent,
CancellableEvent {
    private final Player player;
    private final PlayerHand hand;
    private final ItemStack itemStack;
    private final ItemAnimation animation;
    private long itemUseDuration;
    private boolean cancelled = false;

    public PlayerBeginItemUseEvent(@NotNull Player player, @NotNull PlayerHand hand, @NotNull ItemStack itemStack, @NotNull ItemAnimation animation, long itemUseDuration) {
        this.player = player;
        this.hand = hand;
        this.itemStack = itemStack;
        this.animation = animation;
        this.itemUseDuration = itemUseDuration;
    }

    @Override
    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public PlayerHand getHand() {
        return this.hand;
    }

    @Override
    @NotNull
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @NotNull
    public ItemAnimation getAnimation() {
        return this.animation;
    }

    public long getItemUseDuration() {
        return this.itemUseDuration;
    }

    public void setItemUseDuration(long itemUseDuration) {
        Check.argCondition(itemUseDuration < 0L, "Item use duration cannot be negative");
        this.itemUseDuration = itemUseDuration;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

