/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.fluid;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.minestom.server.registry.FluidRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Fluid implements Keyed
{
    EMPTY(Key.key("minecraft:empty")),
    FLOWING_WATER(Key.key("minecraft:flowing_water")),
    WATER(Key.key("minecraft:water")),
    FLOWING_LAVA(Key.key("minecraft:flowing_lava")),
    LAVA(Key.key("minecraft:lava"));

    private static final Fluid[] VALUES;
    @NotNull
    private final Key id;

    private Fluid(Key id) {
        this.id = id;
        FluidRegistries.fluids.put(id, this);
    }

    @Override
    @NotNull
    public Key key() {
        return this.id;
    }

    public short getId() {
        return (short)this.ordinal();
    }

    @NotNull
    public String toString() {
        return "[" + String.valueOf(this.id) + "]";
    }

    @Nullable
    public static Fluid fromId(short id) {
        if (id >= 0 && id < VALUES.length) {
            return VALUES[id];
        }
        return null;
    }

    static {
        VALUES = Fluid.values();
    }
}

