/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block.predicate;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minestom.server.MinecraftServer;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.gamedata.tags.Tag;
import net.minestom.server.gamedata.tags.TagManager;
import net.minestom.server.instance.block.Block;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface BlockTypeFilter
extends Predicate<Block> {
    public static final NetworkBuffer.Type<BlockTypeFilter> NETWORK_TYPE = new NetworkBuffer.Type<BlockTypeFilter>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, BlockTypeFilter value) {
            BlockTypeFilter blockTypeFilter = value;
            Objects.requireNonNull(blockTypeFilter);
            BlockTypeFilter blockTypeFilter2 = blockTypeFilter;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Blocks.class, Tag.class}, (Object)blockTypeFilter2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Blocks blocks = (Blocks)blockTypeFilter2;
                    buffer.write(NetworkBuffer.VAR_INT, blocks.blocks.size() + 1);
                    for (Block block : blocks.blocks) {
                        buffer.write(NetworkBuffer.VAR_INT, block.id());
                    }
                    break;
                }
                case 1: {
                    Tag tag = (Tag)blockTypeFilter2;
                    buffer.write(NetworkBuffer.VAR_INT, 0);
                    buffer.write(NetworkBuffer.STRING, tag.tag.name());
                }
            }
        }

        @Override
        public BlockTypeFilter read(@NotNull NetworkBuffer buffer) {
            int count = buffer.read(NetworkBuffer.VAR_INT) - 1;
            if (count == -1) {
                return new Tag(buffer.read(NetworkBuffer.STRING));
            }
            ArrayList<Block> blocks = new ArrayList<Block>(count);
            for (int i = 0; i < count; ++i) {
                blocks.add(Block.fromBlockId(buffer.read(NetworkBuffer.VAR_INT)));
            }
            return new Blocks(blocks);
        }
    };
    public static final Codec<BlockTypeFilter> CODEC = new Codec<BlockTypeFilter>(){

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable BlockTypeFilter value) {
            BlockTypeFilter blockTypeFilter = value;
            Objects.requireNonNull(blockTypeFilter);
            BlockTypeFilter blockTypeFilter2 = blockTypeFilter;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Blocks.class, Tag.class}, (Object)blockTypeFilter2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Blocks blocks = (Blocks)blockTypeFilter2;
                    if (blocks.blocks.size() == 1) {
                        yield new Result.Ok<D>(coder.createString(blocks.blocks.getFirst().name()));
                    }
                    Transcoder.ListBuilder<D> list = coder.createList(blocks.blocks.size());
                    for (Block block : blocks.blocks) {
                        list.add(coder.createString(block.name()));
                    }
                    yield new Result.Ok<D>(list.build());
                }
                case 1 -> {
                    Tag tag = (Tag)blockTypeFilter2;
                    yield new Result.Ok<D>(coder.createString("#" + tag.tag.name()));
                }
            };
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<BlockTypeFilter> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            List list;
            Result<String> stringResult = coder.getString(value);
            if (stringResult instanceof Result.Ok) {
                String string;
                Result.Ok ok = (Result.Ok)stringResult;
                String string2 = string = (String)ok.value();
                return new Result.Ok<BlockTypeFilter>((BlockTypeFilter)((Object)(string2.startsWith("#") ? new Tag(string2.substring(1)) : new Blocks(Objects.requireNonNull(Block.fromKey(string2))))));
            }
            Result listResult = coder.getList(value);
            if (!(listResult instanceof Result.Ok)) return listResult.cast();
            Result.Ok ok = (Result.Ok)listResult;
            try {
                List list2 = (List)ok.value();
                list = list2;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            ArrayList<Block> blocks = new ArrayList<Block>(list.size());
            for (Object entry : list) {
                String string;
                Result<String> itemResult = coder.getString(entry);
                if (!(itemResult instanceof Result.Ok)) return itemResult.cast();
                ok = (Result.Ok)itemResult;
                String item = string = (String)ok.value();
                blocks.add(Objects.requireNonNull(Block.fromKey(item)));
            }
            return new Result.Ok<BlockTypeFilter>(new Blocks(blocks));
        }
    };

    public record Tag(@NotNull net.minestom.server.gamedata.tags.Tag tag) implements BlockTypeFilter
    {
        private static final TagManager TAG_MANAGER = Objects.requireNonNull(MinecraftServer.getTagManager());

        public Tag(@NotNull String namespaceId) {
            this(Objects.requireNonNull(TAG_MANAGER.getTag(Tag.BasicType.BLOCKS, namespaceId), "No such block tag: " + namespaceId));
        }

        @Override
        public boolean test(Block block) {
            return this.tag.contains(block.key());
        }
    }

    public record Blocks(@NotNull List<Block> blocks) implements BlockTypeFilter
    {
        public Blocks(@NotNull List<Block> blocks) {
            blocks = List.copyOf(blocks);
        }

        public Blocks(Block ... blocks) {
            this(List.of(blocks));
        }

        @Override
        public boolean test(@NotNull Block block) {
            int blockId = block.id();
            for (Block b : this.blocks) {
                if (blockId != b.id()) continue;
                return true;
            }
            return false;
        }
    }
}

