/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.instrument;

import net.kyori.adventure.text.Component;
import net.minestom.server.ServerFlag;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.item.instrument.InstrumentImpl;
import net.minestom.server.item.instrument.Instruments;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Holder;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.sound.SoundEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public sealed interface Instrument
extends ProtocolObject,
Instruments
permits InstrumentImpl {
    @NotNull
    public static final NetworkBuffer.Type<Instrument> REGISTRY_NETWORK_TYPE = NetworkBufferTemplate.template(SoundEvent.NETWORK_TYPE, Instrument::soundEvent, NetworkBuffer.FLOAT, Instrument::useDuration, NetworkBuffer.FLOAT, Instrument::range, NetworkBuffer.COMPONENT, Instrument::description, InstrumentImpl::new);
    @NotNull
    public static final Codec<Instrument> REGISTRY_CODEC = StructCodec.struct("sound_event", SoundEvent.CODEC, Instrument::soundEvent, "use_duration", Codec.FLOAT, Instrument::useDuration, "range", Codec.FLOAT, Instrument::range, "description", Codec.COMPONENT, Instrument::description, InstrumentImpl::new);
    @NotNull
    public static final NetworkBuffer.Type<Holder<Instrument>> NETWORK_TYPE = Holder.networkType(Registries::instrument, REGISTRY_NETWORK_TYPE);
    @NotNull
    public static final Codec<Holder<Instrument>> CODEC = Holder.codec(Registries::instrument, REGISTRY_CODEC);

    @NotNull
    public static Instrument create(@NotNull SoundEvent soundEvent, float useDuration, float range, @NotNull Component description) {
        return new InstrumentImpl(soundEvent, useDuration, range, description);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<Instrument> createDefaultRegistry() {
        return DynamicRegistry.create("minecraft:instrument", REGISTRY_CODEC, Registry.Resource.INSTRUMENTS);
    }

    @NotNull
    public SoundEvent soundEvent();

    public float useDuration();

    default public int useDurationTicks() {
        return (int)(this.useDuration() * (float)ServerFlag.SERVER_TICKS_PER_SECOND);
    }

    public float range();

    @NotNull
    public Component description();

    public static final class Builder {
        private SoundEvent soundEvent;
        private float useDuration;
        private float range;
        private Component description;

        private Builder() {
        }

        @NotNull
        public Builder soundEvent(@NotNull SoundEvent soundEvent) {
            this.soundEvent = soundEvent;
            return this;
        }

        @NotNull
        public Builder useDuration(float useDuration) {
            this.useDuration = useDuration;
            return this;
        }

        @NotNull
        public Builder range(float range) {
            this.range = range;
            return this;
        }

        @NotNull
        public Builder description(@NotNull Component description) {
            this.description = description;
            return this;
        }

        @NotNull
        public Instrument build() {
            return new InstrumentImpl(this.soundEvent, this.useDuration, this.range, this.description);
        }
    }
}

