/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener;

import net.minestom.server.entity.Player;
import net.minestom.server.entity.PlayerHand;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.player.PlayerChangeHeldSlotEvent;
import net.minestom.server.network.packet.client.play.ClientHeldItemChangePacket;
import net.minestom.server.utils.MathUtils;

public class PlayerHeldListener {
    public static void heldListener(ClientHeldItemChangePacket packet, Player player) {
        if (!MathUtils.isBetween(packet.slot(), 0, 8)) {
            return;
        }
        byte newSlot = (byte)packet.slot();
        byte oldSlot = player.getHeldSlot();
        PlayerChangeHeldSlotEvent changeHeldSlotEvent = new PlayerChangeHeldSlotEvent(player, oldSlot, newSlot);
        EventDispatcher.call(changeHeldSlotEvent);
        if (!changeHeldSlotEvent.isCancelled()) {
            byte resultSlot = changeHeldSlotEvent.getNewSlot();
            if (resultSlot != newSlot) {
                player.setHeldItemSlot(resultSlot);
            } else {
                player.refreshHeldSlot(resultSlot);
            }
        } else {
            player.setHeldItemSlot(oldSlot);
        }
        if (player.getItemUseHand() != PlayerHand.OFF) {
            player.refreshActiveHand(false, false, false);
            player.clearItemUse();
        }
    }
}

